/*
 * Decompiled with CFR 0.152.
 */
package eventstore;

import eventstore.AggregateMemento;
import eventstore.Commit;
import eventstore.EventMessage;
import eventstore.EventMessage$;
import eventstore.Example;
import eventstore.IEventStream;
import eventstore.IPipelineHook;
import eventstore.IStoreEvents;
import eventstore.InMemoryPersistenceEngine;
import eventstore.Logging;
import eventstore.Logging$class;
import eventstore.OptimisticEventStore;
import eventstore.Snapshot;
import eventstore.SomeDomainEvent;
import java.util.UUID;
import org.slf4j.Logger;
import scala.App;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;

public final class Example$
implements App,
Logging {
    public static final Example$ MODULE$;
    private final UUID StreamId;
    private IStoreEvents store;
    private final String loggerName;
    private final Logger log;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;
    private volatile boolean bitmap$0;

    static {
        new Example$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger log$lzycompute() {
        Example$ example$ = this;
        synchronized (example$) {
            if (!this.bitmap$0) {
                this.log = Logging$class.log(this);
                this.bitmap$0 = true;
            }
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return this.bitmap$0 ? this.log : this.log$lzycompute();
    }

    @Override
    public void eventstore$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer x$1) {
        this.scala$App$$initCode = x$1;
    }

    public String[] args() {
        return App.class.args((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.class.delayedInit((App)this, body2);
    }

    public void main(String[] args) {
        App.class.main((App)this, (String[])args);
    }

    private UUID StreamId() {
        return this.StreamId;
    }

    private IStoreEvents store() {
        return this.store;
    }

    private void store_$eq(IStoreEvents x$1) {
        this.store = x$1;
    }

    public void run() {
        this.log().warn("I am starting up");
        this.OpenOrCreateStream();
        this.AppendToStream();
        this.TakeSnapshot();
        this.LoadFromSnapshotForwardAndAppend();
    }

    public IStoreEvents WireupEventStore() {
        return new OptimisticEventStore(new InMemoryPersistenceEngine(), (Iterable<IPipelineHook>)((Iterable)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
    }

    public void DispatchCommit(Commit commit2) {
        try {
            commit2.events().foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(EventMessage event) {
                    Predef$.MODULE$.println((Object)event.body());
                }
            });
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"Cannot dispatch");
        }
    }

    private void OpenOrCreateStream() {
        SomeDomainEvent event;
        IEventStream stream = this.store().openStream(this.StreamId(), 0, Integer.MAX_VALUE);
        SomeDomainEvent x$3 = event = new SomeDomainEvent("Initial event.");
        Map<String, Object> x$4 = EventMessage$.MODULE$.apply$default$1();
        stream.add(new EventMessage(x$4, x$3));
        stream.commitChanges(UUID.randomUUID());
    }

    private void AppendToStream() {
        SomeDomainEvent event;
        IEventStream stream = this.store().openStream(this.StreamId(), Integer.MIN_VALUE, Integer.MAX_VALUE);
        SomeDomainEvent x$5 = event = new SomeDomainEvent("Second event.");
        Map<String, Object> x$6 = EventMessage$.MODULE$.apply$default$1();
        stream.add(new EventMessage(x$6, x$5));
        stream.commitChanges(UUID.randomUUID());
    }

    private void TakeSnapshot() {
        AggregateMemento memento = new AggregateMemento("snapshot");
        this.store().advanced().addSnapshot(new Snapshot(this.StreamId(), 2, memento));
    }

    private void LoadFromSnapshotForwardAndAppend() {
        SomeDomainEvent event;
        Snapshot latestSnapshot = (Snapshot)this.store().advanced().getSnapshot(this.StreamId(), Integer.MAX_VALUE).get();
        IEventStream stream = this.store().openStream(latestSnapshot, Integer.MAX_VALUE);
        SomeDomainEvent x$1 = event = new SomeDomainEvent("Third event (first one after a snapshot).");
        Map<String, Object> x$2 = EventMessage$.MODULE$.apply$default$1();
        stream.add(new EventMessage(x$2, x$1));
        stream.commitChanges(UUID.randomUUID());
    }

    public final void delayedEndpoint$eventstore$Example$1() {
        this.StreamId = UUID.randomUUID();
        this.store = this.WireupEventStore();
        this.run();
    }

    private Example$() {
        MODULE$ = this;
        App.class.$init$((App)this);
        Logging$class.$init$(this);
        this.delayedInit((Function0<BoxedUnit>)new Example.delayedInit.body(this));
    }
}

