/*
 * Decompiled with CFR 0.152.
 */
package eventstore;

import eventstore.Commit;
import eventstore.ConcurrencyException;
import eventstore.DuplicateCommitException;
import eventstore.DuplicateCommitException$;
import eventstore.EventDateTime$;
import eventstore.EventMessage;
import eventstore.ICommitEvents;
import eventstore.IEventStream;
import eventstore.Snapshot;
import java.util.UUID;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\u0001\u0003\u0001\u0015\u0011Qc\u00149uS6L7\u000f^5d\u000bZ,g\u000e^*ue\u0016\fWNC\u0001\u0004\u0003))g/\u001a8ugR|'/Z\u0002\u0001'\r\u0001a\u0001\u0004\t\u0003\u000f)i\u0011\u0001\u0003\u0006\u0002\u0013\u0005)1oY1mC&\u00111\u0002\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u00055qQ\"\u0001\u0002\n\u0005=\u0011!\u0001D%Fm\u0016tGo\u0015;sK\u0006l\u0007\u0002C\t\u0001\u0005\u000b\u0007I\u0011\u0001\n\u0002\u0011M$(/Z1n\u0013\u0012,\u0012a\u0005\t\u0003)]q!!D\u000b\n\u0005Y\u0011\u0011a\u00029bG.\fw-Z\u0005\u00031e\u0011AaR;jI*\u0011aC\u0001\u0005\t7\u0001\u0011\t\u0011)A\u0005'\u0005I1\u000f\u001e:fC6LE\r\t\u0005\t;\u0001\u0011\t\u0011)A\u0005=\u0005Y\u0001/\u001a:tSN$XM\\2f!\tiq$\u0003\u0002!\u0005\ti\u0011jQ8n[&$XI^3oiNDQA\t\u0001\u0005\u0002\r\na\u0001P5oSRtDc\u0001\u0013&MA\u0011Q\u0002\u0001\u0005\u0006#\u0005\u0002\ra\u0005\u0005\u0006;\u0005\u0002\rA\b\u0005\u0006E\u0001!\t\u0001\u000b\u000b\u0006I%R3\u0006\r\u0005\u0006#\u001d\u0002\ra\u0005\u0005\u0006;\u001d\u0002\rA\b\u0005\u0006Y\u001d\u0002\r!L\u0001\f[&t'+\u001a<jg&|g\u000e\u0005\u0002\b]%\u0011q\u0006\u0003\u0002\u0004\u0013:$\b\"B\u0019(\u0001\u0004i\u0013aC7bqJ+g/[:j_:DQA\t\u0001\u0005\u0002M\"B\u0001\n\u001b:u!)QG\ra\u0001m\u0005A1O\\1qg\"|G\u000f\u0005\u0002\u000eo%\u0011\u0001H\u0001\u0002\t':\f\u0007o\u001d5pi\")QD\ra\u0001=!)\u0011G\ra\u0001[!9A\b\u0001a\u0001\n\u0013i\u0014!C2p[6LG\u000f^3e+\u0005q\u0004cA E\r6\t\u0001I\u0003\u0002B\u0005\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003\u0007\"\t!bY8mY\u0016\u001cG/[8o\u0013\t)\u0005I\u0001\u0003MSN$\bCA\u0007H\u0013\tA%A\u0001\u0007Fm\u0016tG/T3tg\u0006<W\rC\u0004K\u0001\u0001\u0007I\u0011B&\u0002\u001b\r|W.\\5ui\u0016$w\fJ3r)\tau\n\u0005\u0002\b\u001b&\u0011a\n\u0003\u0002\u0005+:LG\u000fC\u0004Q\u0013\u0006\u0005\t\u0019\u0001 \u0002\u0007a$\u0013\u0007\u0003\u0004S\u0001\u0001\u0006KAP\u0001\u000bG>lW.\u001b;uK\u0012\u0004\u0003b\u0002+\u0001\u0001\u0004%I!P\u0001\u0007KZ,g\u000e^:\t\u000fY\u0003\u0001\u0019!C\u0005/\u0006QQM^3oiN|F%Z9\u0015\u00051C\u0006b\u0002)V\u0003\u0003\u0005\rA\u0010\u0005\u00075\u0002\u0001\u000b\u0015\u0002 \u0002\u000f\u00154XM\u001c;tA!9A\f\u0001a\u0001\n\u0003i\u0016AE;oG>lW.\u001b;uK\u0012DU-\u00193feN,\u0012A\u0018\t\u0005\u007f}\u000b\u0007.\u0003\u0002a\u0001\n\u0019Q*\u00199\u0011\u0005\t,gBA\u0004d\u0013\t!\u0007\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003M\u001e\u0014aa\u0015;sS:<'B\u00013\t!\tIg.D\u0001k\u0015\tYG.\u0001\u0003mC:<'\"A7\u0002\t)\fg/Y\u0005\u0003_*\u0014aa\u00142kK\u000e$\bbB9\u0001\u0001\u0004%\tA]\u0001\u0017k:\u001cw.\\7jiR,G\rS3bI\u0016\u00148o\u0018\u0013fcR\u0011Aj\u001d\u0005\b!B\f\t\u00111\u0001_\u0011\u0019)\b\u0001)Q\u0005=\u0006\u0019RO\\2p[6LG\u000f^3e\u0011\u0016\fG-\u001a:tA!9q\u000f\u0001a\u0001\n\u0003i\u0016\u0001E2p[6LG\u000f^3e\u0011\u0016\fG-\u001a:t\u0011\u001dI\b\u00011A\u0005\u0002i\fAcY8n[&$H/\u001a3IK\u0006$WM]:`I\u0015\fHC\u0001'|\u0011\u001d\u0001\u00060!AA\u0002yCa! \u0001!B\u0013q\u0016!E2p[6LG\u000f^3e\u0011\u0016\fG-\u001a:tA!Aq\u0010\u0001a\u0001\n\u0003\t\t!A\u0006jI\u0016tG/\u001b4jKJ\u001cXCAA\u0002!\u0011y\u0014QA\n\n\u0007\u0005\u001d\u0001IA\u0002TKRD\u0011\"a\u0003\u0001\u0001\u0004%\t!!\u0004\u0002\u001f%$WM\u001c;jM&,'o]0%KF$2\u0001TA\b\u0011%\u0001\u0016\u0011BA\u0001\u0002\u0004\t\u0019\u0001\u0003\u0005\u0002\u0014\u0001\u0001\u000b\u0015BA\u0002\u00031IG-\u001a8uS\u001aLWM]:!\u0011\u001d\t9\u0002\u0001C\u0001\u00033\tqbY8n[&$H/\u001a3Fm\u0016tGo]\u000b\u0003\u00037\u0001R!!\b\u0002,\u0019sA!a\b\u0002*9!\u0011\u0011EA\u0014\u001b\t\t\u0019CC\u0002\u0002&\u0011\ta\u0001\u0010:p_Rt\u0014\"A\u0005\n\u0005YA\u0011\u0002BA\u0017\u0003_\u0011\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0003-!Aq!a\r\u0001\t\u0003\tI\"A\tv]\u000e|W.\\5ui\u0016$WI^3oiND\u0011\"a\u000e\u0001\u0001\u0004%I!!\u000f\u0002\u001f}\u001bw.\\7jiN+\u0017/^3oG\u0016,\u0012!\f\u0005\n\u0003{\u0001\u0001\u0019!C\u0005\u0003\u007f\t1cX2p[6LGoU3rk\u0016t7-Z0%KF$2\u0001TA!\u0011!\u0001\u00161HA\u0001\u0002\u0004i\u0003bBA#\u0001\u0001\u0006K!L\u0001\u0011?\u000e|W.\\5u'\u0016\fX/\u001a8dK\u0002B\u0011\"!\u0013\u0001\u0001\u0004%I!!\u000f\u0002\u001f}\u001bHO]3b[J+g/[:j_:D\u0011\"!\u0014\u0001\u0001\u0004%I!a\u0014\u0002'}\u001bHO]3b[J+g/[:j_:|F%Z9\u0015\u00071\u000b\t\u0006\u0003\u0005Q\u0003\u0017\n\t\u00111\u0001.\u0011\u001d\t)\u0006\u0001Q!\n5\n\u0001cX:ue\u0016\fWNU3wSNLwN\u001c\u0011\t\u000f\u0005e\u0003\u0001\"\u0001\u0002:\u0005q1m\\7nSR\u001cV-];f]\u000e,\u0007bBA/\u0001\u0011\u0005\u0011\u0011H\u0001\u000fgR\u0014X-Y7SKZL7/[8o\u0011\u001d\t\t\u0007\u0001C\t\u0003G\na\u0002]8qk2\fG/Z*ue\u0016\fW\u000eF\u0004M\u0003K\n9'!\u001b\t\r1\ny\u00061\u0001.\u0011\u0019\t\u0014q\fa\u0001[!A\u00111NA0\u0001\u0004\ti'A\u0004d_6l\u0017\u000e^:\u0011\r\u0005u\u00111FA8!\ri\u0011\u0011O\u0005\u0004\u0003g\u0012!AB\"p[6LG\u000fC\u0004\u0002x\u0001!I!!\u001f\u0002+\r|\u0007/\u001f+p\u0007>lW.\u001b;fI\"+\u0017\rZ3sgR\u0019A*a\u001f\t\u0011\u0005u\u0014Q\u000fa\u0001\u0003_\naaY8n[&$\bbBAA\u0001\u0011%\u00111Q\u0001\rG>\u0004\u0018\u0010V8Fm\u0016tGo\u001d\u000b\n\u0019\u0006\u0015\u0015qQAE\u0003\u001bCa\u0001LA@\u0001\u0004i\u0003BB\u0019\u0002\u0000\u0001\u0007Q\u0006C\u0004\u0002\f\u0006}\u0004\u0019A\u0017\u0002\u001f\r,(O]3oiJ+g/[:j_:D\u0001\"! \u0002\u0000\u0001\u0007\u0011q\u000e\u0005\b\u0003#\u0003A\u0011AAJ\u0003\r\tG\r\u001a\u000b\u0004\u0019\u0006U\u0005bBAL\u0003\u001f\u0003\rAR\u0001\u0010k:\u001cw.\\7ji\u0016$WI^3oi\"9\u00111\u0014\u0001\u0005\u0002\u0005u\u0015!D2p[6LGo\u00115b]\u001e,7\u000fF\u0002M\u0003?Cq!!)\u0002\u001a\u0002\u00071#\u0001\u0005d_6l\u0017\u000e^%e\u0011\u001d\t)\u000b\u0001C\t\u0003O\u000b!\u0002[1t\u0007\"\fgnZ3t)\t\tI\u000bE\u0002\b\u0003WK1!!,\t\u0005\u001d\u0011un\u001c7fC:Dq!!-\u0001\t#\t\u0019,\u0001\bqKJ\u001c\u0018n\u001d;DQ\u0006tw-Z:\u0015\u00071\u000b)\fC\u0004\u0002\"\u0006=\u0006\u0019A\n\t\u000f\u0005e\u0006\u0001\"\u0005\u0002<\u0006\u0011\"-^5mI\u000e{W.\\5u\u0003R$X-\u001c9u)\u0011\ty'!0\t\u000f\u0005\u0005\u0016q\u0017a\u0001'!9\u0011\u0011\u0019\u0001\u0005\u0002\u0005\r\u0017\u0001D2mK\u0006\u00148\t[1oO\u0016\u001cH#\u0001'")
public class OptimisticEventStream
implements IEventStream {
    private final UUID streamId;
    private final ICommitEvents persistence;
    private List<EventMessage> eventstore$OptimisticEventStream$$committed;
    private List<EventMessage> events;
    private Map<String, Object> uncommittedHeaders;
    private Map<String, Object> committedHeaders;
    private Set<UUID> identifiers;
    private int eventstore$OptimisticEventStream$$_commitSequence;
    private int eventstore$OptimisticEventStream$$_streamRevision;

    @Override
    public UUID streamId() {
        return this.streamId;
    }

    public List<EventMessage> eventstore$OptimisticEventStream$$committed() {
        return this.eventstore$OptimisticEventStream$$committed;
    }

    public void eventstore$OptimisticEventStream$$committed_$eq(List<EventMessage> x$1) {
        this.eventstore$OptimisticEventStream$$committed = x$1;
    }

    private List<EventMessage> events() {
        return this.events;
    }

    private void events_$eq(List<EventMessage> x$1) {
        this.events = x$1;
    }

    @Override
    public Map<String, Object> uncommittedHeaders() {
        return this.uncommittedHeaders;
    }

    public void uncommittedHeaders_$eq(Map<String, Object> x$1) {
        this.uncommittedHeaders = x$1;
    }

    @Override
    public Map<String, Object> committedHeaders() {
        return this.committedHeaders;
    }

    public void committedHeaders_$eq(Map<String, Object> x$1) {
        this.committedHeaders = x$1;
    }

    public Set<UUID> identifiers() {
        return this.identifiers;
    }

    public void identifiers_$eq(Set<UUID> x$1) {
        this.identifiers = x$1;
    }

    @Override
    public Iterable<EventMessage> committedEvents() {
        return this.eventstore$OptimisticEventStream$$committed();
    }

    @Override
    public Iterable<EventMessage> uncommittedEvents() {
        return this.events();
    }

    private int eventstore$OptimisticEventStream$$_commitSequence() {
        return this.eventstore$OptimisticEventStream$$_commitSequence;
    }

    public void eventstore$OptimisticEventStream$$_commitSequence_$eq(int x$1) {
        this.eventstore$OptimisticEventStream$$_commitSequence = x$1;
    }

    private int eventstore$OptimisticEventStream$$_streamRevision() {
        return this.eventstore$OptimisticEventStream$$_streamRevision;
    }

    public void eventstore$OptimisticEventStream$$_streamRevision_$eq(int x$1) {
        this.eventstore$OptimisticEventStream$$_streamRevision = x$1;
    }

    @Override
    public int commitSequence() {
        return this.eventstore$OptimisticEventStream$$_commitSequence();
    }

    @Override
    public int streamRevision() {
        return this.eventstore$OptimisticEventStream$$_streamRevision();
    }

    public void populateStream(int minRevision, int maxRevision, Iterable<Commit> commits) {
        commits.foreach((Function1)new Serializable(this, minRevision, maxRevision){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OptimisticEventStream $outer;
            private final int minRevision$1;
            private final int maxRevision$1;

            public final void apply(Commit commit2) {
                this.$outer.identifiers_$eq((Set<UUID>)((Set)this.$outer.identifiers().$plus((Object)commit2.commitId())));
                this.$outer.eventstore$OptimisticEventStream$$_commitSequence_$eq(commit2.commitSequence());
                int currentRevision = commit2.streamRevision() - commit2.events().size() + 1;
                if (currentRevision <= this.maxRevision$1) {
                    this.$outer.eventstore$OptimisticEventStream$$copyToCommitedHeaders(commit2);
                    this.$outer.eventstore$OptimisticEventStream$$copyToEvents(this.minRevision$1, this.maxRevision$1, currentRevision, commit2);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.minRevision$1 = minRevision$1;
                this.maxRevision$1 = maxRevision$1;
            }
        });
    }

    public void eventstore$OptimisticEventStream$$copyToCommitedHeaders(Commit commit2) {
        commit2.headers().keys().foreach((Function1)new Serializable(this, commit2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OptimisticEventStream $outer;
            private final Commit commit$1;

            public final void apply(String key) {
                this.$outer.committedHeaders_$eq((Map<String, Object>)this.$outer.committedHeaders().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), this.commit$1.headers().apply((Object)key))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.commit$1 = commit$1;
            }
        });
    }

    public void eventstore$OptimisticEventStream$$copyToEvents(int minRevision, int maxRevision, int currentRevision, Commit commit2) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Object object = new Object();
            try {
                IntRef curr = IntRef.create((int)currentRevision);
                commit2.events().foreach((Function1)new Serializable(this, minRevision, maxRevision, curr, object){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ OptimisticEventStream $outer;
                    private final int minRevision$2;
                    private final int maxRevision$2;
                    private final IntRef curr$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(EventMessage event) {
                        if (this.curr$1.elem > this.maxRevision$2) {
                            throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                        }
                        ++this.curr$1.elem;
                        if (this.curr$1.elem >= this.minRevision$2) {
                            this.$outer.eventstore$OptimisticEventStream$$committed_$eq((List<EventMessage>)((List)this.$outer.eventstore$OptimisticEventStream$$committed().$colon$plus((Object)event, List$.MODULE$.canBuildFrom())));
                            this.$outer.eventstore$OptimisticEventStream$$_streamRevision_$eq(this.curr$1.elem - 1);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.minRevision$2 = minRevision$2;
                        this.maxRevision$2 = maxRevision$2;
                        this.curr$1 = curr$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                nonLocalReturnControl2.value$mcV$sp();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    @Override
    public void add(EventMessage uncommitedEvent) {
        this.events_$eq((List<EventMessage>)((List)this.events().$colon$plus((Object)uncommitedEvent, List$.MODULE$.canBuildFrom())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void commitChanges(UUID commitId) {
        if (this.identifiers().contains((Object)commitId)) {
            throw new DuplicateCommitException(DuplicateCommitException$.MODULE$.$lessinit$greater$default$1());
        }
        if (!this.hasChanges()) return;
        try {
            this.persistChanges(commitId);
            return;
        }
        catch (ConcurrencyException concurrencyException) {
            Seq<Commit> commits = this.persistence.getFrom(this.streamId(), this.streamRevision() + 1, Integer.MAX_VALUE);
            this.populateStream(this.streamRevision() + 1, Integer.MAX_VALUE, (Iterable<Commit>)commits);
            throw concurrencyException;
        }
    }

    public boolean hasChanges() {
        return this.events().size() > 0;
    }

    public void persistChanges(UUID commitId) {
        Commit attempt = this.buildCommitAttempt(commitId);
        this.persistence.commit(attempt);
        this.populateStream(this.streamRevision() + 1, attempt.streamRevision(), (Iterable<Commit>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Commit[]{attempt}))));
        this.clearChanges();
    }

    public Commit buildCommitAttempt(UUID commitId) {
        long ts = EventDateTime$.MODULE$.now();
        return new Commit(this.streamId(), this.streamRevision() + this.events().size(), commitId, this.commitSequence() + 1, ts, (Map<String, Object>)this.uncommittedHeaders().toMap(Predef$.MODULE$.$conforms()), this.events());
    }

    @Override
    public void clearChanges() {
        this.events_$eq((List<EventMessage>)this.events().takeWhile((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(EventMessage x$1) {
                return false;
            }
        }));
        this.uncommittedHeaders_$eq((Map<String, Object>)((Map)this.uncommittedHeaders().takeWhile((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> x$2) {
                return false;
            }
        })));
    }

    public OptimisticEventStream(UUID streamId, ICommitEvents persistence) {
        this.streamId = streamId;
        this.persistence = persistence;
        this.eventstore$OptimisticEventStream$$committed = Nil$.MODULE$;
        this.events = Nil$.MODULE$;
        this.uncommittedHeaders = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.committedHeaders = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.identifiers = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        this.eventstore$OptimisticEventStream$$_commitSequence = 0;
        this.eventstore$OptimisticEventStream$$_streamRevision = 0;
    }

    public OptimisticEventStream(UUID streamId, ICommitEvents persistence, int minRevision, int maxRevision) {
        this(streamId, persistence);
        Seq<Commit> commits = persistence.getFrom(streamId, minRevision, maxRevision);
        this.populateStream(minRevision, maxRevision, (Iterable<Commit>)commits);
        if (minRevision > 0 && this.eventstore$OptimisticEventStream$$committed().size() == 0) {
            throw new Exception("StreamNotFound");
        }
    }

    public OptimisticEventStream(Snapshot snapshot, ICommitEvents persistence, int maxRevision) {
        this(snapshot.streamId(), persistence);
        Seq<Commit> commits = persistence.getFrom(snapshot.streamId(), snapshot.streamRevision(), maxRevision);
        this.populateStream(snapshot.streamRevision() + 1, maxRevision, (Iterable<Commit>)commits);
        this.eventstore$OptimisticEventStream$$_streamRevision_$eq(snapshot.streamRevision() + this.eventstore$OptimisticEventStream$$committed().size());
    }
}

