/*
 * Decompiled with CFR 0.152.
 */
package cakesolutions.kafka.testkit;

import cakesolutions.kafka.testkit.KafkaServer$;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServerStartable;
import org.apache.curator.test.TestingServer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t\u001ds!B\u0015+\u0011\u0003\td!B\u001a+\u0011\u0003!\u0004\"B\u001e\u0002\t\u0003a\u0004bB\u001f\u0002\u0005\u0004%IA\u0010\u0005\u0007\u000f\u0006\u0001\u000b\u0011B \t\u000b!\u000bA\u0011B%\t\u000f5\u000b!\u0019!C\u0001\u001d\"1Q,\u0001Q\u0001\n=CqAX\u0001C\u0002\u0013\u0005a\n\u0003\u0004`\u0003\u0001\u0006Ia\u0014\u0005\bA\u0006\u0011\r\u0011\"\u0001O\u0011\u0019\t\u0017\u0001)A\u0005\u001f\")!-\u0001C\u0005G\")10\u0001C\u0005y\"1q0\u0001C\u0005\u0003\u0003A\u0011\"!\u0004\u0002#\u0003%\t!a\u0004\t\u0013\u0005\u0015\u0012!%A\u0005\u0002\u0005=\u0001\"CA\u0014\u0003E\u0005I\u0011AA\u0015\r\u0015\u0019$FAA\u0017\u0011)\tyC\u0005BC\u0002\u0013\u0005\u0011\u0011\u0007\u0005\n\u0003g\u0011\"\u0011!Q\u0001\n)C\u0011B\u001c\n\u0003\u0006\u0004%\t!!\r\t\u0013\u0005U\"C!A!\u0002\u0013Q\u0005\"CA\u001c%\t\u0005\t\u0015!\u0003P\u0011\u0019Y$\u0003\"\u0001\u0002:!A\u0001O\u0005b\u0001\n\u0013\t\u0019\u0005C\u0004\u0002FI\u0001\u000b\u0011B9\t\u0013\u0005\u001d#C1A\u0005\n\u0005%\u0003\u0002CA+%\u0001\u0006I!a\u0013\t\u0013\u0005]#C1A\u0005\n\u0005e\u0003\u0002CA8%\u0001\u0006I!a\u0017\t\u0013\u0005E$C1A\u0005\n\u0005M\u0004bBA;%\u0001\u0006I\u0001\u001a\u0005\n\u0003o\u0012\"\u0019!C\u0005\u0003sB\u0001\"!!\u0013A\u0003%\u00111\u0010\u0005\b\u0003\u0007\u0013B\u0011AAC\u0011\u001d\t9I\u0005C\u0001\u0003\u000bCq!!#\u0013\t\u0003\tY\tC\u0005\u0002|J\t\n\u0011\"\u0001\u0002~\"9!1\u0001\n\u0005\u0002\t\u0015\u0001\"\u0003B %E\u0005I\u0011\u0001B!\u0003-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u000b\u0005-b\u0013a\u0002;fgR\\\u0017\u000e\u001e\u0006\u0003[9\nQa[1gW\u0006T\u0011aL\u0001\u000eG\u0006\\Wm]8mkRLwN\\:\u0004\u0001A\u0011!'A\u0007\u0002U\tY1*\u00194lCN+'O^3s'\t\tQ\u0007\u0005\u00027s5\tqGC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQtG\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\n1\u0001\\8h+\u0005y\u0004C\u0001!F\u001b\u0005\t%B\u0001\"D\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005!\u0015aA8sO&\u0011a)\u0011\u0002\u0007\u0019><w-\u001a:\u0002\t1|w\rI\u0001\u0014e\u0006tGm\\7Bm\u0006LG.\u00192mKB{'\u000f\u001e\u000b\u0002\u0015B\u0011agS\u0005\u0003\u0019^\u00121!\u00138u\u00035!WMZ1vYR\u001cuN\u001c4jOV\tq\n\u0005\u0003Q/jSfBA)V!\t\u0011v'D\u0001T\u0015\t!\u0006'\u0001\u0004=e>|GOP\u0005\u0003-^\na\u0001\u0015:fI\u00164\u0017B\u0001-Z\u0005\ri\u0015\r\u001d\u0006\u0003-^\u0002\"\u0001U.\n\u0005qK&AB*ue&tw-\u0001\beK\u001a\fW\u000f\u001c;D_:4\u0017n\u001a\u0011\u0002+\u0011,g-Y;mi\u000e{gn];nKJ\u001cuN\u001c4jO\u00061B-\u001a4bk2$8i\u001c8tk6,'oQ8oM&<\u0007%A\u000beK\u001a\fW\u000f\u001c;Qe>$WoY3s\u0007>tg-[4\u0002-\u0011,g-Y;miB\u0013x\u000eZ;dKJ\u001cuN\u001c4jO\u0002\nAb\u0019:fCR,7i\u001c8gS\u001e$R\u0001Z6n_f\u0004\"!Z5\u000e\u0003\u0019T!a\u001a5\u0002\rM,'O^3s\u0015\u0005i\u0013B\u00016g\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u000b1d\u0001\u0019\u0001&\u0002\tA|'\u000f\u001e\u0005\u0006]2\u0001\rAS\u0001\u000eu>|7.Z3qKJ\u0004vN\u001d;\t\u000bAd\u0001\u0019A9\u0002\r1|w\rR5s!\t\u0011x/D\u0001t\u0015\t!X/\u0001\u0002j_*\ta/\u0001\u0003kCZ\f\u0017B\u0001=t\u0005\u00111\u0015\u000e\\3\t\u000bid\u0001\u0019A(\u0002\u0019=$\b.\u001a:PaRLwN\\:\u0002\u001b\r\u0014X-\u0019;f)\u0016l\u0007\u000fR5s)\t\tX\u0010C\u0003\u007f\u001b\u0001\u0007!,A\u0005eSJ\u0004&/\u001a4jq\u0006QA-\u001a7fi\u00164\u0015\u000e\\3\u0015\t\u0005\r\u0011\u0011\u0002\t\u0004m\u0005\u0015\u0011bAA\u0004o\t!QK\\5u\u0011\u0019\tYA\u0004a\u0001c\u0006!\u0001/\u0019;i\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0003\u0016\u0004\u0015\u0006M1FAA\u000b!\u0011\t9\"!\t\u000e\u0005\u0005e!\u0002BA\u000e\u0003;\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005}q'\u0001\u0006b]:|G/\u0019;j_:LA!a\t\u0002\u001a\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0006\u0016\u0004\u001f\u0006M1C\u0001\n6\u0003%Y\u0017MZ6b!>\u0014H/F\u0001K\u0003)Y\u0017MZ6b!>\u0014H\u000fI\u0001\u000fu>|7.Z3qKJ\u0004vN\u001d;!\u0003-Y\u0017MZ6b\u0007>tg-[4\u0015\u0011\u0005m\u0012QHA \u0003\u0003\u0002\"A\r\n\t\u0011\u0005=\u0002\u0004%AA\u0002)CqA\u001c\r\u0011\u0002\u0003\u0007!\n\u0003\u0005\u00028a\u0001\n\u00111\u0001P+\u0005\t\u0018a\u00027pO\u0012K'\u000fI\u0001\u0017E>|Go\u001d;sCB\u001cVM\u001d<fe\u0006#GM]3tgV\u0011\u00111\n\t\u0005\u0003\u001b\n\u0019&\u0004\u0002\u0002P)\u0019\u0011\u0011K;\u0002\t1\fgnZ\u0005\u00049\u0006=\u0013a\u00062p_R\u001cHO]1q'\u0016\u0014h/\u001a:BI\u0012\u0014Xm]:!\u0003!Q8nU3sm\u0016\u0014XCAA.!\u0011\ti&a\u001b\u000e\u0005\u0005}#\u0002BA1\u0003G\nA\u0001^3ti*!\u0011QMA4\u0003\u001d\u0019WO]1u_JT1!!\u001bD\u0003\u0019\t\u0007/Y2iK&!\u0011QNA0\u00055!Vm\u001d;j]\u001e\u001cVM\u001d<fe\u0006I!p[*feZ,'\u000fI\u0001\u0007G>tg-[4\u0016\u0003\u0011\fqaY8oM&<\u0007%A\u0006lC\u001a\\\u0017mU3sm\u0016\u0014XCAA>!\r)\u0017QP\u0005\u0004\u0003\u007f2'\u0001F&bM.\f7+\u001a:wKJ\u001cF/\u0019:uC\ndW-\u0001\u0007lC\u001a\\\u0017mU3sm\u0016\u0014\b%A\u0004ti\u0006\u0014H/\u001e9\u0015\u0005\u0005\r\u0011!B2m_N,\u0017aB2p]N,X.Z\u000b\u0007\u0003\u001b\u000b\t,!2\u0015\u001d\u0005=\u0015\u0011ZAg\u0003#\fY.!=\u0002xB1\u0011\u0011SAN\u0003CsA!a%\u0002\u0018:\u0019!+!&\n\u0003aJ1!!'8\u0003\u001d\u0001\u0018mY6bO\u0016LA!!(\u0002 \n\u00191+Z9\u000b\u0007\u0005eu\u0007E\u00047\u0003G\u000b9+a1\n\u0007\u0005\u0015vG\u0001\u0004UkBdWM\r\t\u0006m\u0005%\u0016QV\u0005\u0004\u0003W;$AB(qi&|g\u000e\u0005\u0003\u00020\u0006EF\u0002\u0001\u0003\b\u0003g+#\u0019AA[\u0005\rYU-_\t\u0005\u0003o\u000bi\fE\u00027\u0003sK1!a/8\u0005\u001dqu\u000e\u001e5j]\u001e\u00042ANA`\u0013\r\t\tm\u000e\u0002\u0004\u0003:L\b\u0003BAX\u0003\u000b$q!a2&\u0005\u0004\t)LA\u0003WC2,X\r\u0003\u0004\u0002L\u0016\u0002\rAW\u0001\u0006i>\u0004\u0018n\u0019\u0005\u0007\u0003\u001f,\u0003\u0019\u0001&\u0002)\u0015D\b/Z2uK\u0012tU/\\(g%\u0016\u001cwN\u001d3t\u0011\u001d\t\u0019.\na\u0001\u0003+\fq\u0001^5nK>,H\u000fE\u00027\u0003/L1!!78\u0005\u0011auN\\4\t\u000f\u0005uW\u00051\u0001\u0002`\u0006y1.Z=EKN,'/[1mSj,'\u000f\u0005\u0004\u0002b\u00065\u0018QV\u0007\u0003\u0003GTA!!:\u0002h\u0006i1/\u001a:jC2L'0\u0019;j_:TA!!;\u0002l\u000611m\\7n_:T1!LA4\u0013\u0011\ty/a9\u0003\u0019\u0011+7/\u001a:jC2L'0\u001a:\t\u000f\u0005MX\u00051\u0001\u0002v\u0006\tb/\u00197vK\u0012+7/\u001a:jC2L'0\u001a:\u0011\r\u0005\u0005\u0018Q^Ab\u0011!\tI0\nI\u0001\u0002\u0004y\u0015AD2p]N,X.\u001a:D_:4\u0017nZ\u0001\u0012G>t7/^7fI\u0011,g-Y;mi\u00122TCBA\u0015\u0003\u007f\u0014\t\u0001B\u0004\u00024\u001a\u0012\r!!.\u0005\u000f\u0005\u001dgE1\u0001\u00026\u00069\u0001O]8ek\u000e,WC\u0002B\u0004\u0005K\u0011I\u0003\u0006\u0006\u0002\u0004\t%!1\u0006B\u001b\u0005wAqAa\u0003(\u0001\u0004\u0011i!A\u0004sK\u000e|'\u000fZ:\u0011\r\u0005E%q\u0002B\n\u0013\u0011\u0011\t\"a(\u0003\u0011%#XM]1cY\u0016\u0004\u0002B!\u0006\u0003 \t\r\"qE\u0007\u0003\u0005/QAA!\u0007\u0003\u001c\u0005A\u0001O]8ek\u000e,'O\u0003\u0003\u0003\u001e\u0005-\u0018aB2mS\u0016tGo]\u0005\u0005\u0005C\u00119B\u0001\bQe>$WoY3s%\u0016\u001cwN\u001d3\u0011\t\u0005=&Q\u0005\u0003\b\u0003g;#\u0019AA[!\u0011\tyK!\u000b\u0005\u000f\u0005\u001dwE1\u0001\u00026\"9!QF\u0014A\u0002\t=\u0012!D6fsN+'/[1mSj,'\u000f\u0005\u0004\u0002b\nE\"1E\u0005\u0005\u0005g\t\u0019O\u0001\u0006TKJL\u0017\r\\5{KJDqAa\u000e(\u0001\u0004\u0011I$A\bwC2,XmU3sS\u0006d\u0017N_3s!\u0019\t\tO!\r\u0003(!A!QH\u0014\u0011\u0002\u0003\u0007q*\u0001\bqe>$WoY3s\u0007>tg-[4\u0002#A\u0014x\u000eZ;dK\u0012\"WMZ1vYR$C'\u0006\u0004\u0002*\t\r#Q\t\u0003\b\u0003gC#\u0019AA[\t\u001d\t9\r\u000bb\u0001\u0003k\u0003")
public final class KafkaServer {
    private final int kafkaPort;
    private final int zookeeperPort;
    private final File logDir;
    private final String bootstrapServerAddress;
    private final TestingServer zkServer;
    private final KafkaConfig config;
    private final KafkaServerStartable kafkaServer;

    public static scala.collection.immutable.Map<String, String> $lessinit$greater$default$3() {
        return KafkaServer$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return KafkaServer$.MODULE$.$lessinit$greater$default$2();
    }

    public static int $lessinit$greater$default$1() {
        return KafkaServer$.MODULE$.$lessinit$greater$default$1();
    }

    public static scala.collection.immutable.Map<String, String> defaultProducerConfig() {
        return KafkaServer$.MODULE$.defaultProducerConfig();
    }

    public static scala.collection.immutable.Map<String, String> defaultConsumerConfig() {
        return KafkaServer$.MODULE$.defaultConsumerConfig();
    }

    public static scala.collection.immutable.Map<String, String> defaultConfig() {
        return KafkaServer$.MODULE$.defaultConfig();
    }

    public int kafkaPort() {
        return this.kafkaPort;
    }

    public int zookeeperPort() {
        return this.zookeeperPort;
    }

    private File logDir() {
        return this.logDir;
    }

    private String bootstrapServerAddress() {
        return this.bootstrapServerAddress;
    }

    private TestingServer zkServer() {
        return this.zkServer;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private KafkaServerStartable kafkaServer() {
        return this.kafkaServer;
    }

    public void startup() {
        KafkaServer$.MODULE$.cakesolutions$kafka$testkit$KafkaServer$$log().info("ZK Connect String: {}", new Object[]{this.zkServer().getConnectString()});
        this.zkServer().start();
        this.kafkaServer().startup();
        KafkaServer$.MODULE$.cakesolutions$kafka$testkit$KafkaServer$$log().info(new StringBuilder(24).append("Started kafka on port [").append(this.kafkaPort()).append("]").toString());
    }

    public void close() {
        KafkaServer$.MODULE$.cakesolutions$kafka$testkit$KafkaServer$$log().info(new StringBuilder(25).append("Stopping kafka on port [").append(this.kafkaPort()).append("]").toString());
        this.kafkaServer().shutdown();
        this.zkServer().stop();
        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> KafkaServer$.MODULE$.cakesolutions$kafka$testkit$KafkaServer$$deleteFile(this.logDir())).failed().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.printStackTrace();
            return BoxedUnit.UNIT;
        });
    }

    public <Key, Value> Seq<Tuple2<Option<Key>, Value>> consume(String topic, int expectedNumOfRecords, long timeout, Deserializer<Key> keyDeserializer, Deserializer<Value> valueDeserializer, scala.collection.immutable.Map<String, String> consumerConfig) {
        Vector vector;
        scala.collection.immutable.Map extendedConfig = consumerConfig.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.bootstrapServerAddress()));
        try (KafkaConsumer consumer = new KafkaConsumer((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)extendedConfig).asJava(), keyDeserializer, valueDeserializer);){
            ConsumerRecords records;
            consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic, (List)Nil$.MODULE$)).asJava());
            ArrayBuffer collected = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            long start = System.currentTimeMillis();
            for (int total = 0; total < expectedNumOfRecords && System.currentTimeMillis() < start + timeout; total += records.count()) {
                records = consumer.poll(100L);
                Iterable kvs = (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)records).asScala()).map((Function1 & Serializable & scala.Serializable)r -> new Tuple2((Object)Option$.MODULE$.apply(r.key()), r.value()), Iterable$.MODULE$.canBuildFrom());
                collected.$plus$plus$eq((TraversableOnce)kvs);
            }
            if (collected.size() < expectedNumOfRecords) {
                throw package$.MODULE$.error(new StringBuilder(60).append("Did not receive expected amount records. Expected ").append(expectedNumOfRecords).append(" but got ").append(collected.size()).append(".").toString());
            }
            vector = collected.toVector();
        }
        return vector;
    }

    public <Key, Value> scala.collection.immutable.Map<String, String> consume$default$6() {
        return KafkaServer$.MODULE$.defaultConsumerConfig();
    }

    public <Key, Value> void produce(Iterable<ProducerRecord<Key, Value>> records, Serializer<Key> keySerializer, Serializer<Value> valueSerializer, scala.collection.immutable.Map<String, String> producerConfig) {
        scala.collection.immutable.Map extendedConfig = producerConfig.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.bootstrapServerAddress()));
        KafkaProducer producer = new KafkaProducer((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)extendedConfig).asJava(), keySerializer, valueSerializer);
        try {
            records.foreach((Function1 & Serializable & scala.Serializable)r -> producer.send(r));
        }
        finally {
            producer.flush();
            producer.close();
        }
    }

    public <Key, Value> scala.collection.immutable.Map<String, String> produce$default$4() {
        return KafkaServer$.MODULE$.defaultProducerConfig();
    }

    public KafkaServer(int kafkaPort, int zookeeperPort, scala.collection.immutable.Map<String, String> kafkaConfig) {
        this.kafkaPort = kafkaPort;
        this.zookeeperPort = zookeeperPort;
        this.logDir = KafkaServer$.MODULE$.cakesolutions$kafka$testkit$KafkaServer$$createTempDir("kafka-local");
        this.bootstrapServerAddress = new StringBuilder(10).append("localhost:").append(((Object)BoxesRunTime.boxToInteger((int)kafkaPort)).toString()).toString();
        this.zkServer = new TestingServer(zookeeperPort, false);
        this.config = KafkaServer$.MODULE$.cakesolutions$kafka$testkit$KafkaServer$$createConfig(kafkaPort, zookeeperPort, this.logDir(), kafkaConfig);
        this.kafkaServer = new KafkaServerStartable(this.config());
    }
}

