/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij.converters.implementations;

import ij.ImagePlus;
import ij.gui.NewImage;
import net.haesleinhuepf.clij.CLIJ;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.util.ElapsedTime;
import net.haesleinhuepf.clij.converters.implementations.ClearCLBufferToImagePlusConverter;
import net.haesleinhuepf.clij.test.TestUtilities;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ClearCLBufferToImagePlusConverterTest {
    ImagePlus result1;
    ImagePlus result2;

    @Ignore
    @Test
    public void testByteImageConversion() {
        CLIJ clij = CLIJ.getInstance();
        ClearCLBufferToImagePlusConverter biConverter = new ClearCLBufferToImagePlusConverter();
        biConverter.setCLIJ(clij);
        ImagePlus imp1 = NewImage.createByteImage((String)"text", (int)1024, (int)1024, (int)25, (int)2);
        ImagePlus imp2 = NewImage.createByteImage((String)"text", (int)1024, (int)1024, (int)25, (int)2);
        ClearCLBuffer buffer1 = (ClearCLBuffer)clij.convert((Object)imp1, ClearCLBuffer.class);
        ClearCLBuffer buffer2 = (ClearCLBuffer)clij.convert((Object)imp2, ClearCLBuffer.class);
        imp1.close();
        imp2.close();
        for (int i = 0; i < 10; ++i) {
            ElapsedTime.measureForceOutput((String)"conversion", () -> {
                this.result1 = biConverter.convert(buffer1);
            });
            ElapsedTime.measureForceOutput((String)"legacy conversion", () -> {
                this.result2 = biConverter.convertLegacy(buffer2);
            });
            Assert.assertTrue((boolean)TestUtilities.clBuffersEqual((CLIJ)clij, (ClearCLBuffer)buffer1, (ClearCLBuffer)buffer2, (double)0.001));
            Assert.assertTrue((boolean)TestUtilities.compareImages((ImagePlus)this.result1, (ImagePlus)this.result2, (double)0.001));
            this.result1.close();
            this.result2.close();
        }
        buffer1.close();
        buffer2.close();
    }

    @Ignore
    @Test
    public void testShortImageConversion() {
        CLIJ clij = CLIJ.getInstance();
        ClearCLBufferToImagePlusConverter biConverter = new ClearCLBufferToImagePlusConverter();
        biConverter.setCLIJ(clij);
        ImagePlus imp1 = NewImage.createShortImage((String)"text", (int)1024, (int)1024, (int)25, (int)2);
        ImagePlus imp2 = NewImage.createShortImage((String)"text", (int)1024, (int)1024, (int)25, (int)2);
        ClearCLBuffer buffer1 = (ClearCLBuffer)clij.convert((Object)imp1, ClearCLBuffer.class);
        ClearCLBuffer buffer2 = (ClearCLBuffer)clij.convert((Object)imp2, ClearCLBuffer.class);
        imp1.close();
        imp2.close();
        for (int i = 0; i < 10; ++i) {
            ElapsedTime.measureForceOutput((String)"conversion", () -> {
                this.result1 = biConverter.convert(buffer1);
            });
            ElapsedTime.measureForceOutput((String)"legacy conversion", () -> {
                this.result2 = biConverter.convertLegacy(buffer2);
            });
            Assert.assertTrue((boolean)TestUtilities.clBuffersEqual((CLIJ)clij, (ClearCLBuffer)buffer1, (ClearCLBuffer)buffer2, (double)0.001));
            Assert.assertTrue((boolean)TestUtilities.compareImages((ImagePlus)this.result1, (ImagePlus)this.result2, (double)0.001));
            this.result1.close();
            this.result2.close();
        }
        buffer1.close();
        buffer2.close();
    }

    @Ignore
    @Test
    public void testFloatImageConversion() {
        CLIJ clij = CLIJ.getInstance();
        ClearCLBufferToImagePlusConverter biConverter = new ClearCLBufferToImagePlusConverter();
        biConverter.setCLIJ(clij);
        ImagePlus imp1 = NewImage.createFloatImage((String)"text", (int)1024, (int)1024, (int)15, (int)2);
        ImagePlus imp2 = NewImage.createFloatImage((String)"text", (int)1024, (int)1024, (int)15, (int)2);
        ClearCLBuffer buffer1 = (ClearCLBuffer)clij.convert((Object)imp1, ClearCLBuffer.class);
        ClearCLBuffer buffer2 = (ClearCLBuffer)clij.convert((Object)imp2, ClearCLBuffer.class);
        imp1.close();
        imp2.close();
        for (int i = 0; i < 10; ++i) {
            ElapsedTime.measureForceOutput((String)"conversion", () -> {
                this.result1 = biConverter.convert(buffer1);
            });
            ElapsedTime.measureForceOutput((String)"legacy conversion", () -> {
                this.result2 = biConverter.convertLegacy(buffer2);
            });
            Assert.assertTrue((boolean)TestUtilities.clBuffersEqual((CLIJ)clij, (ClearCLBuffer)buffer1, (ClearCLBuffer)buffer2, (double)0.001));
            Assert.assertTrue((boolean)TestUtilities.compareImages((ImagePlus)this.result1, (ImagePlus)this.result2, (double)0.001));
            this.result1.close();
            this.result2.close();
        }
        buffer1.close();
        buffer2.close();
    }
}

