/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij.converters.implementations;

import ij.ImagePlus;
import net.haesleinhuepf.clij.CLIJ;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import org.junit.Assert;
import org.junit.Test;

public class ConverterOverflowTest {
    @Test
    public void test16to8bitConversion() {
        CLIJ clij = CLIJ.getInstance();
        ClearCLBuffer buffer = clij.create(new long[]{1L, 1L, 1L}, NativeTypeEnum.UnsignedShort);
        ClearCLBuffer converted = clij.create(buffer.getDimensions(), NativeTypeEnum.UnsignedByte);
        clij.op().set(buffer, Float.valueOf(255.0f));
        clij.op().copy(buffer, converted);
        ImagePlus imp = clij.pull(converted);
        Assert.assertEquals((float)imp.getProcessor().get(0, 0), (float)255.0f, (float)0.0f);
        Assert.assertEquals((double)clij.op().sumPixels(converted), (double)255.0, (double)0.0);
        clij.op().addImageAndScalar(buffer, converted, Float.valueOf(1.0f));
        imp = clij.pull(converted);
        Assert.assertEquals((float)imp.getProcessor().get(0, 0), (float)255.0f, (float)0.0f);
        Assert.assertEquals((double)clij.op().sumPixels(converted), (double)255.0, (double)0.0);
        buffer.close();
        converted.close();
    }

    @Test
    public void test32to8bitConversion() {
        CLIJ clij = CLIJ.getInstance();
        ClearCLBuffer buffer = clij.create(new long[]{1L, 1L, 1L}, NativeTypeEnum.Float);
        ClearCLBuffer converted = clij.create(buffer.getDimensions(), NativeTypeEnum.UnsignedByte);
        clij.op().set(buffer, Float.valueOf(255.0f));
        clij.op().copy(buffer, converted);
        ImagePlus imp = clij.pull(converted);
        Assert.assertEquals((float)imp.getProcessor().get(0, 0), (float)255.0f, (float)0.0f);
        Assert.assertEquals((double)clij.op().sumPixels(converted), (double)255.0, (double)0.0);
        clij.op().addImageAndScalar(buffer, converted, Float.valueOf(1.0f));
        imp = clij.pull(converted);
        Assert.assertEquals((float)imp.getProcessor().get(0, 0), (float)255.0f, (float)0.0f);
        Assert.assertEquals((double)clij.op().sumPixels(converted), (double)255.0, (double)0.0);
        buffer.close();
        converted.close();
    }
}

