/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij.converters.implementations;

import ij.ImagePlus;
import ij.gui.NewImage;
import net.haesleinhuepf.clij.CLIJ;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.util.ElapsedTime;
import net.haesleinhuepf.clij.converters.implementations.ClearCLBufferToImagePlusConverter;
import net.haesleinhuepf.clij.converters.implementations.ImagePlusToClearCLBufferConverter;
import net.haesleinhuepf.clij.test.TestUtilities;
import org.junit.Assert;
import org.junit.Test;

public class ImagePlusToClearCLBufferConverterTest {
    ClearCLBuffer temp1;
    ClearCLBuffer temp2;

    @Test
    public void testByteImageConversion() {
        CLIJ clij = CLIJ.getInstance();
        ImagePlusToClearCLBufferConverter ibConverter = new ImagePlusToClearCLBufferConverter();
        ibConverter.setCLIJ(clij);
        ClearCLBufferToImagePlusConverter biConverter = new ClearCLBufferToImagePlusConverter();
        biConverter.setCLIJ(clij);
        ImagePlus imp1 = NewImage.createByteImage((String)"text", (int)1024, (int)1024, (int)25, (int)2);
        ImagePlus imp2 = NewImage.createByteImage((String)"text", (int)1024, (int)1024, (int)25, (int)2);
        for (int i = 0; i < 10; ++i) {
            ElapsedTime.measureForceOutput((String)"conversion", () -> {
                this.temp1 = ibConverter.convert(imp1);
            });
            ElapsedTime.measureForceOutput((String)"legacy conversion", () -> {
                this.temp2 = ibConverter.convertLegacy(imp2);
            });
            Assert.assertTrue((boolean)TestUtilities.clBuffersEqual((CLIJ)clij, (ClearCLBuffer)this.temp1, (ClearCLBuffer)this.temp2, (double)0.001));
            this.temp1.close();
            this.temp2.close();
        }
        imp1.close();
        imp2.close();
    }

    @Test
    public void testShortImageConversion() {
        CLIJ clij = CLIJ.getInstance();
        ImagePlusToClearCLBufferConverter ibConverter = new ImagePlusToClearCLBufferConverter();
        ibConverter.setCLIJ(clij);
        ClearCLBufferToImagePlusConverter biConverter = new ClearCLBufferToImagePlusConverter();
        biConverter.setCLIJ(clij);
        ImagePlus imp1 = NewImage.createShortImage((String)"text", (int)1024, (int)1024, (int)25, (int)2);
        ImagePlus imp2 = NewImage.createShortImage((String)"text", (int)1024, (int)1024, (int)25, (int)2);
        for (int i = 0; i < 10; ++i) {
            ElapsedTime.measureForceOutput((String)"conversion", () -> {
                this.temp1 = ibConverter.convert(imp1);
            });
            ElapsedTime.measureForceOutput((String)"legacy conversion", () -> {
                this.temp2 = ibConverter.convertLegacy(imp2);
            });
            Assert.assertTrue((boolean)TestUtilities.clBuffersEqual((CLIJ)clij, (ClearCLBuffer)this.temp1, (ClearCLBuffer)this.temp2, (double)0.001));
            this.temp1.close();
            this.temp2.close();
        }
        imp1.close();
        imp2.close();
    }

    @Test
    public void testFloatImageConversion() {
        CLIJ clij = CLIJ.getInstance();
        ImagePlusToClearCLBufferConverter ibConverter = new ImagePlusToClearCLBufferConverter();
        ibConverter.setCLIJ(clij);
        ClearCLBufferToImagePlusConverter biConverter = new ClearCLBufferToImagePlusConverter();
        biConverter.setCLIJ(clij);
        ImagePlus imp1 = NewImage.createFloatImage((String)"text", (int)1024, (int)1024, (int)25, (int)2);
        ImagePlus imp2 = NewImage.createFloatImage((String)"text", (int)1024, (int)1024, (int)25, (int)2);
        for (int i = 0; i < 10; ++i) {
            ElapsedTime.measureForceOutput((String)"conversion", () -> {
                this.temp1 = ibConverter.convert(imp1);
            });
            ElapsedTime.measureForceOutput((String)"legacy conversion", () -> {
                this.temp2 = ibConverter.convertLegacy(imp2);
            });
            Assert.assertTrue((boolean)TestUtilities.clBuffersEqual((CLIJ)clij, (ClearCLBuffer)this.temp1, (ClearCLBuffer)this.temp2, (double)0.001));
            this.temp1.close();
            this.temp2.close();
        }
        imp1.close();
        imp2.close();
    }

    @Test
    public void testSpecialConversion() {
        CLIJ clij = CLIJ.getInstance();
        ImagePlus imp1 = TestUtilities.getRandomImage((int)100, (int)100, (int)3, (int)16, (float)0.0f, (float)15.0f);
        ImagePlusToClearCLBufferConverter ibConverter = new ImagePlusToClearCLBufferConverter();
        ibConverter.setCLIJ(clij);
        ElapsedTime.measureForceOutput((String)"conversion", () -> {
            this.temp1 = ibConverter.convert(imp1);
        });
        ElapsedTime.measureForceOutput((String)"legacy conversion", () -> {
            this.temp2 = ibConverter.convertLegacy(imp1);
        });
        Assert.assertTrue((boolean)TestUtilities.clBuffersEqual((CLIJ)clij, (ClearCLBuffer)this.temp1, (ClearCLBuffer)this.temp2, (double)0.001));
        this.temp1.close();
        this.temp2.close();
    }
}

