/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij.test;

import junit.framework.TestCase;
import net.haesleinhuepf.clij.CLIJ;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLImage;
import net.haesleinhuepf.clij.kernels.Kernels;
import net.haesleinhuepf.clij.test.TestUtilities;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.realtransform.AffineTransform2D;
import net.imglib2.realtransform.AffineTransform3D;
import org.junit.Test;

public class AffineTransformTest {
    @Test
    public void testTranslateBuffer() {
        float[] imageFlt = new float[]{1.0f, 4.0f, 6.0f, 9.0f};
        float[] referenceImageFlt = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 4.0f, 0.0f, 0.0f, 0.0f, 0.0f, 6.0f, 9.0f};
        ArrayImg img = ArrayImgs.floats((float[])imageFlt, (long[])new long[]{2L, 2L});
        ArrayImg referenceImg = ArrayImgs.floats((float[])referenceImageFlt, (long[])new long[]{6L, 2L});
        CLIJ clij = CLIJ.getInstance();
        ClearCLBuffer input = (ClearCLBuffer)clij.convert((Object)img, ClearCLBuffer.class);
        ClearCLBuffer reference = (ClearCLBuffer)clij.convert((Object)referenceImg, ClearCLBuffer.class);
        ClearCLBuffer output = clij.create(reference);
        AffineTransform3D at = new AffineTransform3D();
        at.translate(new double[]{4.0, 0.0, 0.0});
        Kernels.affineTransform3D((CLIJ)clij, (ClearCLBuffer)input, (ClearCLBuffer)output, (AffineTransform3D)at);
        TestUtilities.printBuffer((CLIJ)clij, (ClearCLBuffer)output);
        TestCase.assertTrue((boolean)TestUtilities.clBuffersEqual((CLIJ)clij, (ClearCLBuffer)output, (ClearCLBuffer)reference, (double)0.0));
        input.close();
        reference.close();
        output.close();
        clij.dispose();
    }

    @Test
    public void testTranslateImage() {
        float[] imageFlt = new float[]{1.0f, 4.0f, 6.0f, 9.0f};
        float[] referenceImageFlt = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 4.0f, 0.0f, 0.0f, 0.0f, 0.0f, 6.0f, 9.0f};
        ArrayImg img = ArrayImgs.floats((float[])imageFlt, (long[])new long[]{2L, 2L});
        ArrayImg referenceImg = ArrayImgs.floats((float[])referenceImageFlt, (long[])new long[]{6L, 2L});
        CLIJ clij = CLIJ.getInstance();
        ClearCLImage input = (ClearCLImage)clij.convert((Object)img, ClearCLImage.class);
        ClearCLImage reference = (ClearCLImage)clij.convert((Object)referenceImg, ClearCLImage.class);
        ClearCLImage output = clij.create(reference);
        AffineTransform2D at = new AffineTransform2D();
        at.translate(new double[]{4.0, 0.0});
        Kernels.affineTransform2D((CLIJ)clij, (ClearCLImage)input, (ClearCLImage)output, (AffineTransform2D)at);
        ClearCLBuffer bufferOutput = (ClearCLBuffer)clij.convert((Object)output, ClearCLBuffer.class);
        ClearCLBuffer referenceOutput = (ClearCLBuffer)clij.convert((Object)reference, ClearCLBuffer.class);
        TestUtilities.printBuffer((CLIJ)clij, (ClearCLBuffer)bufferOutput);
        TestCase.assertTrue((boolean)TestUtilities.clBuffersEqual((CLIJ)clij, (ClearCLBuffer)bufferOutput, (ClearCLBuffer)referenceOutput, (double)0.0));
        input.close();
        reference.close();
        output.close();
        clij.dispose();
    }
}

