/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij.test;

import ij.IJ;
import ij.ImagePlus;
import net.haesleinhuepf.clij.CLIJ;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLImage;
import net.haesleinhuepf.clij.clearcl.util.ElapsedTime;
import net.haesleinhuepf.clij.kernels.Kernels;
import net.haesleinhuepf.clij.test.TestUtilities;
import org.junit.Test;

public class BlurImageVersusBuffersTest {
    @Test
    public void compareImagesAndBufferProcessingTime() {
        CLIJ clij = CLIJ.getInstance();
        ImagePlus testImage = TestUtilities.getRandomImage((int)100, (int)100, (int)100, (int)32, (float)0.0f, (float)100.0f);
        ClearCLBuffer inputBuffer = (ClearCLBuffer)clij.convert((Object)testImage, ClearCLBuffer.class);
        ClearCLBuffer outputBuffer = clij.createCLBuffer(inputBuffer);
        ClearCLImage inputImage = (ClearCLImage)clij.convert((Object)testImage, ClearCLImage.class);
        ClearCLImage outputImage = clij.createCLImage(inputImage);
        float sigma = 5.0f;
        for (int i = 0; i < 3; ++i) {
            ElapsedTime.measureForceOutput((String)"blurSep buffer", () -> Kernels.blur((CLIJ)clij, (ClearCLBuffer)inputBuffer, (ClearCLBuffer)outputBuffer, (Float)Float.valueOf(sigma), (Float)Float.valueOf(sigma), (Float)Float.valueOf(sigma)));
            ElapsedTime.measureForceOutput((String)"blurSep image", () -> Kernels.blur((CLIJ)clij, (ClearCLImage)inputImage, (ClearCLImage)outputImage, (Float)Float.valueOf(sigma), (Float)Float.valueOf(sigma), (Float)Float.valueOf(sigma)));
        }
        inputBuffer.close();
        inputImage.close();
        outputBuffer.close();
        outputImage.close();
        IJ.exit();
        clij.close();
    }
}

