/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij.test;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.plugin.Duplicator;
import java.io.IOException;
import java.util.HashMap;
import junit.framework.TestCase;
import net.haesleinhuepf.clij.CLIJ;
import net.haesleinhuepf.clij.clearcl.ClearCLImage;
import net.haesleinhuepf.clij.kernels.Kernels;
import net.haesleinhuepf.clij.test.TestUtilities;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.view.Views;
import org.junit.Assert;
import org.junit.Test;

public class DoubleFlipTest {
    public static void main(String ... args) throws IOException {
        new ImageJ();
        new DoubleFlipTest().testFlipImageTwiceOnAllDevices();
    }

    @Test
    public void testFlipImageTwiceOnAllDevices() throws IOException {
        for (String deviceName : CLIJ.getAvailableDeviceNames()) {
            CLIJ clij = CLIJ.getInstance((String)deviceName);
            System.out.println("Testing " + deviceName);
            ImagePlus inputImagePlus = IJ.openImage((String)"src/test/resources/flybrain.tif");
            ClearCLImage clImage = (ClearCLImage)clij.convert((Object)inputImagePlus, ClearCLImage.class);
            RandomAccessibleInterval inputImagePlus2 = (RandomAccessibleInterval)clij.convert((Object)clImage, RandomAccessibleInterval.class);
            TestCase.assertTrue((boolean)TestUtilities.compareIterableIntervals((IterableInterval)Views.iterable((RandomAccessibleInterval)inputImagePlus2), (IterableInterval)ImageJFunctions.wrap((ImagePlus)inputImagePlus)));
            Img inputImg = ImageJFunctions.wrap((ImagePlus)inputImagePlus);
            Img outputImg = ImageJFunctions.wrap((ImagePlus)new Duplicator().run(inputImagePlus));
            ClearCLImage srcCLImage = (ClearCLImage)clij.convert((Object)inputImg, ClearCLImage.class);
            ClearCLImage dstCLImage = (ClearCLImage)clij.convert((Object)outputImg, ClearCLImage.class);
            Kernels.flip((CLIJ)clij, (ClearCLImage)srcCLImage, (ClearCLImage)dstCLImage, (Boolean)true, (Boolean)false, (Boolean)false);
            HashMap<String, Object> parameterMap = new HashMap<String, Object>();
            parameterMap.put("src", dstCLImage);
            parameterMap.put("dst", srcCLImage);
            parameterMap.put("flipx", 1);
            parameterMap.put("flipy", 0);
            parameterMap.put("flipz", 0);
            clij.execute("src/main/java/net/haesleinhuepf/clij/kernels/flip.cl", "flip_3d", parameterMap);
            RandomAccessibleInterval lIntermediateResultImg = (RandomAccessibleInterval)clij.convert((Object)dstCLImage, RandomAccessibleInterval.class);
            System.out.println("Should be different:");
            Assert.assertFalse((boolean)TestUtilities.compareIterableIntervals((IterableInterval)Views.iterable((RandomAccessibleInterval)lIntermediateResultImg), (IterableInterval)Views.iterable((RandomAccessibleInterval)inputImg)));
            RandomAccessibleInterval resultImg = (RandomAccessibleInterval)clij.convert((Object)srcCLImage, RandomAccessibleInterval.class);
            System.out.println("Should be same:");
            TestCase.assertTrue((boolean)TestUtilities.compareIterableIntervals((IterableInterval)Views.iterable((RandomAccessibleInterval)resultImg), (IterableInterval)Views.iterable((RandomAccessibleInterval)inputImg)));
            ImageJFunctions.show((RandomAccessibleInterval)resultImg, (String)("res " + deviceName));
            ImageJFunctions.show((RandomAccessibleInterval)inputImg, (String)("inp " + deviceName));
            clImage.close();
            srcCLImage.close();
            dstCLImage.close();
            clij.close();
        }
        IJ.exit();
    }
}

