/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij.test;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.NewImage;
import net.haesleinhuepf.clij.CLIJ;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLImage;
import net.haesleinhuepf.clij.clearcl.enums.ImageChannelDataType;
import net.haesleinhuepf.clij.converters.implementations.RandomAccessibleIntervalToClearCLImageConverter;
import net.haesleinhuepf.clij.kernels.Kernels;
import net.haesleinhuepf.clij.test.TestUtilities;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;
import org.junit.Assert;
import org.junit.Test;

public class ImageConverterTest {
    CLIJ clij = null;

    @Test
    public void testSimpleCopyBackAndForth() {
        for (int i = 0; i < 2; ++i) {
            ImagePlus imp = NewImage.createShortImage((String)"title", (int)512, (int)512, (int)20, (int)2);
            CLIJ clij = CLIJ.getInstance();
            long time = System.currentTimeMillis();
            ClearCLBuffer buffer1 = (ClearCLBuffer)clij.convert((Object)imp, ClearCLBuffer.class);
            System.out.println("Forth took " + (System.currentTimeMillis() - time) + " msec");
            ClearCLBuffer buffer2 = clij.createCLBuffer(buffer1.getDimensions(), buffer1.getNativeType());
            Kernels.copy((CLIJ)clij, (ClearCLBuffer)buffer1, (ClearCLBuffer)buffer2);
            time = System.currentTimeMillis();
            ImagePlus result = (ImagePlus)clij.convert((Object)buffer2, ImagePlus.class);
            System.out.println("Back took " + (System.currentTimeMillis() - time) + " msec");
            result.show();
        }
    }

    @Test
    public void testImgClearCLImageConverter() {
        for (String deviceName : CLIJ.getAvailableDeviceNames()) {
            this.clij = CLIJ.getInstance((String)deviceName);
            System.out.println("Testing device " + deviceName);
            ArrayImg lFloatImg = ArrayImgs.floats((long[])new long[]{5L, 6L, 7L});
            this.fillTestImage((RandomAccessibleInterval)lFloatImg);
            this.testBackAndForthConversionViaCLImage((RandomAccessibleInterval)lFloatImg);
            ArrayImg lUnsignedByteImg = ArrayImgs.unsignedBytes((long[])new long[]{5L, 6L, 7L});
            this.fillTestImage((RandomAccessibleInterval)lUnsignedByteImg);
            this.testBackAndForthConversionViaCLImage((RandomAccessibleInterval)lUnsignedByteImg);
            ArrayImg lByteImg = ArrayImgs.bytes((long[])new long[]{5L, 6L, 7L});
            this.fillTestImage((RandomAccessibleInterval)lByteImg);
            this.testBackAndForthConversionViaCLImage((RandomAccessibleInterval)lByteImg);
            ArrayImg lUnsignedShortImg = ArrayImgs.unsignedShorts((long[])new long[]{5L, 6L, 7L});
            this.fillTestImage((RandomAccessibleInterval)lUnsignedShortImg);
            this.testBackAndForthConversionViaCLImage((RandomAccessibleInterval)lUnsignedShortImg);
            ArrayImg lShortImg = ArrayImgs.shorts((long[])new long[]{5L, 6L, 7L});
            this.fillTestImage((RandomAccessibleInterval)lShortImg);
            this.testBackAndForthConversionViaCLImage((RandomAccessibleInterval)lShortImg);
            this.clij.close();
        }
        IJ.exit();
    }

    @Test
    public void testBufferConversion() {
        this.clij = CLIJ.getInstance();
        ArrayImg lFloatImg = ArrayImgs.floats((long[])new long[]{5L, 6L, 7L});
        this.fillTestImage((RandomAccessibleInterval)lFloatImg);
        CLIJ lCLIJ = this.clij;
        ClearCLBuffer lClearCLBuffer = (ClearCLBuffer)lCLIJ.convert((Object)lFloatImg, ClearCLBuffer.class);
        RandomAccessibleInterval lRAIconvertedTwice = (RandomAccessibleInterval)lCLIJ.convert((Object)lFloatImg, RandomAccessibleInterval.class);
        Assert.assertTrue((boolean)TestUtilities.compareIterableIntervals((IterableInterval)Views.iterable((RandomAccessibleInterval)lFloatImg), (IterableInterval)Views.iterable((RandomAccessibleInterval)lRAIconvertedTwice)));
        lClearCLBuffer.close();
        IJ.exit();
        this.clij.close();
    }

    private <T extends RealType<T>> void fillTestImage(RandomAccessibleInterval<T> lFloatImg) {
        RandomAccess lRandomAccess = lFloatImg.randomAccess();
        lRandomAccess.setPosition(new long[]{1L, 2L, 3L});
        ((RealType)lRandomAccess.get()).setReal(4.0f);
        if (!(lRandomAccess.get() instanceof ByteType) && !(lRandomAccess.get() instanceof UnsignedByteType)) {
            lRandomAccess.setPosition(new long[]{1L, 3L, 3L});
            ((RealType)lRandomAccess.get()).setReal(40000.0f);
        }
    }

    private <T extends RealType<T>> void testBackAndForthConversionViaCLImage(RandomAccessibleInterval<T> lRAI) {
        ClearCLImage lClearCLImage = (ClearCLImage)this.clij.convert(lRAI, ClearCLImage.class);
        RandomAccessibleInterval lRAIconvertedTwice = (RandomAccessibleInterval)this.clij.convert((Object)lClearCLImage, RandomAccessibleInterval.class);
        Assert.assertTrue((boolean)TestUtilities.compareIterableIntervals((IterableInterval)Views.iterable(lRAI), (IterableInterval)Views.iterable((RandomAccessibleInterval)lRAIconvertedTwice)));
        lClearCLImage.close();
    }

    @Test
    public void convertHugeUnsignedShortImageTest() {
        this.clij = CLIJ.getInstance();
        ArrayImg lRAI = ArrayImgs.unsignedShorts((long[])new long[]{10L, 10L});
        RandomAccess lRA = lRAI.randomAccess();
        lRA.setPosition(new long[]{1L, 1L});
        ((UnsignedShortType)lRA.get()).set(40000);
        this.testBackAndForthConversionViaCLImage((RandomAccessibleInterval)lRAI);
        IJ.exit();
        this.clij.close();
    }

    @Test
    public void convertHugeSignedShortImageTest() {
        this.clij = CLIJ.getInstance();
        ArrayImg lRAI = ArrayImgs.shorts((long[])new long[]{1L, 1L});
        RandomAccess lRA = lRAI.randomAccess();
        lRA.setPosition(new long[]{0L, 0L});
        ((ShortType)lRA.get()).setReal(-25400.0f);
        this.testBackAndForthConversionViaCLImage((RandomAccessibleInterval)lRAI);
        IJ.exit();
        this.clij.close();
    }

    @Test
    public void convertHugeFloatImageTest() {
        this.clij = CLIJ.getInstance();
        ArrayImg lRAI = ArrayImgs.floats((long[])new long[]{1L, 1L});
        RandomAccess lRA = lRAI.randomAccess();
        lRA.setPosition(new long[]{0L, 0L});
        ((FloatType)lRA.get()).setReal(-25400.0f);
        this.testBackAndForthConversionViaCLImage((RandomAccessibleInterval)lRAI);
        IJ.exit();
        this.clij.close();
    }

    @Test
    public void testConversionUnsignedShortStackToFloatCLImage() {
        this.clij = CLIJ.getInstance();
        ArrayImg rai = ArrayImgs.unsignedShorts((long[])new long[]{3L, 3L});
        RandomAccess ra = rai.randomAccess();
        ra.setPosition(new int[]{1, 1});
        ((UnsignedShortType)ra.get()).set(4);
        ClearCLImage stack = (ClearCLImage)this.clij.convert((Object)rai, ClearCLImage.class);
        RandomAccessibleInterval rai2 = (RandomAccessibleInterval)this.clij.convert((Object)stack, RandomAccessibleInterval.class);
        ClearCLImage clImage = this.clij.createCLImage(stack.getDimensions(), ImageChannelDataType.Float);
        RandomAccessibleIntervalToClearCLImageConverter.copyRandomAccessibleIntervalToClearCLImage((RandomAccessibleInterval)rai2, (ClearCLImage)clImage);
        ClearCLImage clImage2 = this.clij.createCLImage(stack.getDimensions(), ImageChannelDataType.UnsignedInt16);
        Kernels.copy((CLIJ)this.clij, (ClearCLImage)clImage, (ClearCLImage)clImage2);
        RandomAccessibleInterval rai3 = (RandomAccessibleInterval)this.clij.convert((Object)clImage2, RandomAccessibleInterval.class);
        Assert.assertTrue((boolean)TestUtilities.compareIterableIntervals((IterableInterval)Views.iterable((RandomAccessibleInterval)rai2), (IterableInterval)Views.iterable((RandomAccessibleInterval)rai3)));
        IJ.exit();
        this.clij.close();
    }
}

