/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij.test;

import ij.IJ;
import ij.ImagePlus;
import java.util.HashMap;
import net.haesleinhuepf.clij.CLIJ;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.kernels.Kernels;
import org.junit.Assert;
import org.junit.Test;

public class ImageSizeCLMacroTest {
    @Test
    public void testReadImageSrc1Width() {
        CLIJ clij = CLIJ.getInstance();
        int referenceWidth = 7;
        ClearCLBuffer src1 = clij.createCLBuffer(new long[]{referenceWidth, 2L, 3L}, NativeTypeEnum.Byte);
        ClearCLBuffer src2 = clij.createCLBuffer(new long[]{4L, 5L, 6L}, NativeTypeEnum.Byte);
        ClearCLBuffer dst = clij.createCLBuffer(new long[]{1L, 1L, 1L}, NativeTypeEnum.Byte);
        HashMap<String, ClearCLBuffer> parameters = new HashMap<String, ClearCLBuffer>();
        parameters.put("src1", src1);
        parameters.put("src2", src2);
        parameters.put("dst", dst);
        clij.execute(Kernels.class, "test.cl", "set_pixels_to_width_src1_3d", parameters);
        ImagePlus imp = (ImagePlus)clij.convert((Object)dst, ImagePlus.class);
        int width = imp.getProcessor().get(0, 0);
        Assert.assertEquals((long)referenceWidth, (long)width);
        src1.close();
        src2.close();
        dst.close();
        IJ.exit();
        clij.close();
    }

    @Test
    public void testReadImageSrc12Width() {
        CLIJ clij = CLIJ.getInstance();
        int referenceWidth = 7;
        ClearCLBuffer src1 = clij.createCLBuffer(new long[]{1L, 2L, 3L}, NativeTypeEnum.Byte);
        ClearCLBuffer src2 = clij.createCLBuffer(new long[]{referenceWidth, 5L, 6L}, NativeTypeEnum.Byte);
        ClearCLBuffer dst = clij.createCLBuffer(new long[]{1L, 1L, 1L}, NativeTypeEnum.Byte);
        HashMap<String, ClearCLBuffer> parameters = new HashMap<String, ClearCLBuffer>();
        parameters.put("src1", src1);
        parameters.put("src2", src2);
        parameters.put("dst", dst);
        clij.execute(Kernels.class, "test.cl", "set_pixels_to_width_src2_3d", parameters);
        ImagePlus imp = (ImagePlus)clij.convert((Object)dst, ImagePlus.class);
        int width = imp.getProcessor().get(0, 0);
        Assert.assertEquals((long)referenceWidth, (long)width);
        src1.close();
        src2.close();
        dst.close();
        IJ.exit();
        clij.close();
    }
}

