/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij.test;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.NewImage;
import ij.plugin.Duplicator;
import ij.process.ImageProcessor;
import net.haesleinhuepf.clij.CLIJ;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLImage;
import net.haesleinhuepf.clij.kernels.Kernels;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class KernelsTest {
    ImagePlus testFlyBrain3D;
    ImagePlus testFlyBrain2D;
    ImagePlus testImp1;
    ImagePlus testImp2;
    ImagePlus testImp2D1;
    ImagePlus testImp2D2;
    ImagePlus mask3d;
    ImagePlus mask2d;
    CLIJ clij;

    @Before
    public void initTest() {
        this.testFlyBrain3D = IJ.openImage((String)"src/test/resources/flybrain.tif");
        this.testFlyBrain2D = new Duplicator().run(this.testFlyBrain3D, 1, 1);
        this.testImp1 = NewImage.createImage((String)"", (int)100, (int)100, (int)12, (int)16, (int)1);
        this.testImp2 = NewImage.createImage((String)"", (int)100, (int)100, (int)12, (int)16, (int)1);
        this.mask3d = NewImage.createImage((String)"", (int)100, (int)100, (int)12, (int)16, (int)1);
        for (int z = 0; z < 5; ++z) {
            this.testImp1.setZ(z + 1);
            ImageProcessor ip1 = this.testImp1.getProcessor();
            ip1.set(5, 5, 1);
            ip1.set(6, 6, 1);
            ip1.set(7, 7, 1);
            this.testImp2.setZ(z + 1);
            ImageProcessor ip2 = this.testImp2.getProcessor();
            ip2.set(7, 5, 2);
            ip2.set(6, 6, 2);
            ip2.set(5, 7, 2);
            if (z >= 3) continue;
            this.mask3d.setZ(z + 3);
            ImageProcessor ip3 = this.mask3d.getProcessor();
            ip3.set(2, 2, 1);
            ip3.set(2, 3, 1);
            ip3.set(2, 4, 1);
            ip3.set(3, 2, 1);
            ip3.set(3, 3, 1);
            ip3.set(3, 4, 1);
            ip3.set(4, 2, 1);
            ip3.set(4, 3, 1);
            ip3.set(4, 4, 1);
        }
        this.testImp2D1 = new Duplicator().run(this.testImp1, 1, 1);
        this.testImp2D2 = new Duplicator().run(this.testImp1, 1, 1);
        this.mask2d = new Duplicator().run(this.mask3d, 3, 3);
        if (this.clij == null) {
            this.clij = CLIJ.getInstance();
        }
    }

    @Test
    public void differenceOfGaussian3d() {
        System.out.println("Todo: implement test for DoG");
        ClearCLImage src = (ClearCLImage)this.clij.convert((Object)this.testImp1, ClearCLImage.class);
        ClearCLImage dst = (ClearCLImage)this.clij.convert((Object)this.testImp1, ClearCLImage.class);
        Kernels.differenceOfGaussian((CLIJ)this.clij, (ClearCLImage)src, (ClearCLImage)dst, (Integer)6, (Float)Float.valueOf(1.1f), (Float)Float.valueOf(3.3f));
        src.close();
        dst.close();
    }

    @Test
    public void differenceOfGaussian3dSliceBySlice() {
        System.out.println("Todo: implement test for DoG slice by slice");
        ClearCLImage src = (ClearCLImage)this.clij.convert((Object)this.testImp1, ClearCLImage.class);
        ClearCLImage dst = (ClearCLImage)this.clij.convert((Object)this.testImp1, ClearCLImage.class);
        Kernels.differenceOfGaussianSliceBySlice((CLIJ)this.clij, (ClearCLImage)src, (ClearCLImage)dst, (Integer)6, (Float)Float.valueOf(1.1f), (Float)Float.valueOf(3.3f));
        src.close();
        dst.close();
    }

    @Test
    public void differenceOfGaussian2d() {
        System.out.println("Todo: implement test for DoG");
        ClearCLImage src = (ClearCLImage)this.clij.convert((Object)this.testImp2D1, ClearCLImage.class);
        ClearCLImage dst = (ClearCLImage)this.clij.convert((Object)this.testImp2D1, ClearCLImage.class);
        Kernels.differenceOfGaussian((CLIJ)this.clij, (ClearCLImage)src, (ClearCLImage)dst, (Integer)6, (Float)Float.valueOf(1.1f), (Float)Float.valueOf(3.3f));
        src.close();
        dst.close();
    }

    @Ignore
    @Test
    public void splitStack() {
        ClearCLImage clearCLImage = (ClearCLImage)this.clij.convert((Object)this.testFlyBrain3D, ClearCLImage.class);
        ClearCLImage split1 = this.clij.createCLImage(new long[]{clearCLImage.getWidth(), clearCLImage.getHeight(), clearCLImage.getDepth() / 2L}, clearCLImage.getChannelDataType());
        ClearCLImage split2 = this.clij.createCLImage(new long[]{clearCLImage.getWidth(), clearCLImage.getHeight(), clearCLImage.getDepth() / 2L}, clearCLImage.getChannelDataType());
        Kernels.splitStack((CLIJ)this.clij, (ClearCLImage)clearCLImage, (ClearCLImage[])new ClearCLImage[]{split1, split2});
        Assert.assertTrue((Kernels.sumPixels((CLIJ)this.clij, (ClearCLImage)split1) > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((Kernels.sumPixels((CLIJ)this.clij, (ClearCLImage)split2) > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void splitStack_Buffers() {
        ClearCLBuffer clearCLImage = (ClearCLBuffer)this.clij.convert((Object)this.testFlyBrain3D, ClearCLBuffer.class);
        ClearCLBuffer split1 = this.clij.createCLBuffer(new long[]{clearCLImage.getWidth(), clearCLImage.getHeight(), clearCLImage.getDepth() / 2L}, clearCLImage.getNativeType());
        ClearCLBuffer split2 = this.clij.createCLBuffer(new long[]{clearCLImage.getWidth(), clearCLImage.getHeight(), clearCLImage.getDepth() / 2L}, clearCLImage.getNativeType());
        Kernels.splitStack((CLIJ)this.clij, (ClearCLBuffer)clearCLImage, (ClearCLBuffer[])new ClearCLBuffer[]{split1, split2});
        Assert.assertTrue((Kernels.sumPixels((CLIJ)this.clij, (ClearCLBuffer)split1) > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((Kernels.sumPixels((CLIJ)this.clij, (ClearCLBuffer)split2) > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void tenengradWeights() {
        System.out.println("Todo: implement test for Tenengrad weights");
    }

    @Test
    public void tenengradFusion() {
        System.out.println("Todo: implement test for Tenengrad fusion");
    }
}

