/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij.test;

import ij.ImagePlus;
import ij.gui.NewImage;
import net.haesleinhuepf.clij.CLIJ;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.utilities.CLIJUtilities;
import org.junit.Assert;
import org.junit.Test;

public class MaximumFilterTest {
    private static boolean debug = false;

    @Test
    public void testFloatMaximumSphere2D() {
        ImagePlus imp = NewImage.createFloatImage((String)"image", (int)512, (int)512, (int)1, (int)1);
        imp.getProcessor().setf(256, 256, 1.0f);
        this.checkMaximumSphereFilter(imp, 25);
    }

    @Test
    public void testByteMaximumSphere2D() {
        ImagePlus imp = NewImage.createByteImage((String)"image", (int)512, (int)512, (int)1, (int)1);
        imp.getProcessor().set(256, 256, 1);
        this.checkMaximumSphereFilter(imp, 25);
    }

    @Test
    public void testShortMaximumSphere2D() {
        ImagePlus imp = NewImage.createShortImage((String)"image", (int)512, (int)512, (int)1, (int)1);
        imp.getProcessor().set(256, 256, 1);
        this.checkMaximumSphereFilter(imp, 25);
    }

    @Test
    public void testFloatMaximumSphere3D() {
        ImagePlus imp = NewImage.createFloatImage((String)"image", (int)512, (int)512, (int)10, (int)1);
        imp.setZ(imp.getNSlices() / 2);
        imp.getProcessor().setf(256, 256, 1.0f);
        this.checkMaximumSphereFilter(imp, 25);
    }

    @Test
    public void testByteMaximumSphere3D() {
        ImagePlus imp = NewImage.createByteImage((String)"image", (int)512, (int)512, (int)10, (int)1);
        imp.setZ(imp.getNSlices() / 2);
        imp.getProcessor().set(256, 256, 1);
        this.checkMaximumSphereFilter(imp, 25);
    }

    @Test
    public void testShortMaximumSphere3D() {
        ImagePlus imp = NewImage.createShortImage((String)"image", (int)512, (int)512, (int)10, (int)1);
        imp.setZ(imp.getNSlices() / 2);
        imp.getProcessor().set(256, 256, 1);
        this.checkMaximumSphereFilter(imp, 25);
    }

    private void checkMaximumSphereFilter(ImagePlus imp, int maxRadius) {
        CLIJ clij = CLIJ.getInstance();
        ClearCLBuffer input = clij.push(imp);
        ClearCLBuffer output = clij.create(input);
        for (int radius = 1; radius <= maxRadius; radius += 5) {
            int kernelSize = CLIJUtilities.radiusToKernelSize((int)radius);
            if (imp.getNSlices() > 1) {
                clij.op().maximumSphere(input, output, Integer.valueOf(kernelSize), Integer.valueOf(kernelSize), Integer.valueOf(kernelSize));
            } else {
                clij.op().maximumSphere(input, output, Integer.valueOf(kernelSize), Integer.valueOf(kernelSize));
            }
            ImagePlus result = clij.pull(output);
            if (imp.getNSlices() > 1) {
                result.setZ(result.getNSlices() / 2);
            }
            if (debug) {
                result.show();
                result.setDisplayRange(0.0, 1.0);
                result.updateAndDraw();
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            int numberOfWhitePixels = (int)(result.getStatistics().mean * (double)result.getWidth() * (double)result.getHeight());
            int numberOfAllPixels = result.getWidth() * result.getHeight();
            int numberOfBlackPixels = numberOfAllPixels - numberOfWhitePixels;
            System.out.println("White: " + numberOfWhitePixels);
            System.out.println("Black: " + numberOfBlackPixels);
            Assert.assertTrue((numberOfWhitePixels > 1 ? 1 : 0) != 0);
            Assert.assertTrue((numberOfBlackPixels > 0 ? 1 : 0) != 0);
        }
        input.close();
        output.close();
    }
}

