/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij.test;

import ij.IJ;
import ij.ImagePlus;
import net.haesleinhuepf.clij.CLIJ;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import org.junit.Ignore;
import org.junit.Test;

public class MultipleGPUsTest {
    @Test
    public void listDevices() {
        for (String deviceName : CLIJ.getAvailableDeviceNames()) {
            System.out.println(deviceName);
        }
    }

    @Ignore
    @Test
    public void testMultipleGPUsInParallel() throws InterruptedException {
        CLIJ clijIntel = new CLIJ(0);
        CLIJ clijNvidia = new CLIJ(2);
        ImagePlus imp = IJ.openImage((String)"src/test/resources/t1-head.tif");
        Processor processorIntel = new Processor(clijIntel, imp);
        Processor processorNvidia = new Processor(clijNvidia, imp);
        processorIntel.start();
        processorNvidia.start();
        processorIntel.join();
        processorNvidia.join();
        Thread.sleep(5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(String text) {
        MultipleGPUsTest multipleGPUsTest = this;
        synchronized (multipleGPUsTest) {
            System.out.println("" + System.currentTimeMillis() + "\t" + text);
        }
    }

    class Processor
    extends Thread {
        CLIJ clij;
        ImagePlus imp;

        public Processor(CLIJ clij, ImagePlus imp) {
            this.clij = clij;
            this.imp = imp;
        }

        @Override
        public void run() {
            String gpuName = this.clij.getGPUName();
            MultipleGPUsTest.this.log(gpuName + " start");
            ClearCLBuffer input = this.clij.push(this.imp);
            ClearCLBuffer output = this.clij.create(input);
            MultipleGPUsTest.this.log(gpuName + " copy done");
            float sigma = 25.0f;
            this.clij.op().blur(input, output, Float.valueOf(sigma), Float.valueOf(sigma), Float.valueOf(sigma));
            MultipleGPUsTest.this.log(gpuName + " blur done");
            this.clij.show((Object)output, "Result on " + this.clij.getGPUName());
            MultipleGPUsTest.this.log(gpuName + " finished");
            input.close();
            output.close();
        }
    }
}

