/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2;

import ij.IJ;
import ij.ImagePlus;
import ij.plugin.Duplicator;
import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Stack;
import net.haesleinhuepf.clij.CLIJ;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLImage;
import net.haesleinhuepf.clij.clearcl.ClearCLKernel;
import net.haesleinhuepf.clij.clearcl.enums.ImageChannelDataType;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.clearcl.util.CLKernelExecutor;
import net.haesleinhuepf.clij.clearcl.util.ElapsedTime;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij2.CLIJ2Ops;
import net.haesleinhuepf.clij2.converters.helptypes.Byte1;
import net.haesleinhuepf.clij2.converters.helptypes.Byte2;
import net.haesleinhuepf.clij2.converters.helptypes.Byte3;
import net.haesleinhuepf.clij2.converters.helptypes.Char1;
import net.haesleinhuepf.clij2.converters.helptypes.Char2;
import net.haesleinhuepf.clij2.converters.helptypes.Char3;
import net.haesleinhuepf.clij2.converters.helptypes.Double1;
import net.haesleinhuepf.clij2.converters.helptypes.Double2;
import net.haesleinhuepf.clij2.converters.helptypes.Double3;
import net.haesleinhuepf.clij2.converters.helptypes.Float1;
import net.haesleinhuepf.clij2.converters.helptypes.Float2;
import net.haesleinhuepf.clij2.converters.helptypes.Float3;
import net.haesleinhuepf.clij2.converters.implementations.Byte1ToClearCLBufferConverter;
import net.haesleinhuepf.clij2.converters.implementations.Byte2ToClearCLBufferConverter;
import net.haesleinhuepf.clij2.converters.implementations.Byte3ToClearCLBufferConverter;
import net.haesleinhuepf.clij2.converters.implementations.Char1ToClearCLBufferConverter;
import net.haesleinhuepf.clij2.converters.implementations.Char2ToClearCLBufferConverter;
import net.haesleinhuepf.clij2.converters.implementations.Char3ToClearCLBufferConverter;
import net.haesleinhuepf.clij2.converters.implementations.ClearCLBufferToByte2Converter;
import net.haesleinhuepf.clij2.converters.implementations.ClearCLBufferToByte3Converter;
import net.haesleinhuepf.clij2.converters.implementations.ClearCLBufferToChar2Converter;
import net.haesleinhuepf.clij2.converters.implementations.ClearCLBufferToChar3Converter;
import net.haesleinhuepf.clij2.converters.implementations.ClearCLBufferToDouble2Converter;
import net.haesleinhuepf.clij2.converters.implementations.ClearCLBufferToDouble3Converter;
import net.haesleinhuepf.clij2.converters.implementations.ClearCLBufferToFloat2Converter;
import net.haesleinhuepf.clij2.converters.implementations.ClearCLBufferToFloat3Converter;
import net.haesleinhuepf.clij2.converters.implementations.Double1ToClearCLBufferConverter;
import net.haesleinhuepf.clij2.converters.implementations.Double2ToClearCLBufferConverter;
import net.haesleinhuepf.clij2.converters.implementations.Double3ToClearCLBufferConverter;
import net.haesleinhuepf.clij2.converters.implementations.Float1ToClearCLBufferConverter;
import net.haesleinhuepf.clij2.converters.implementations.Float2ToClearCLBufferConverter;
import net.haesleinhuepf.clij2.converters.implementations.Float3ToClearCLBufferConverter;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.Type;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;

public class CLIJ2
implements CLIJ2Ops {
    private static CLIJ2 instance;
    private final long max_num_bytes;
    private boolean doTimeTracing = false;
    protected CLIJ clij;
    protected boolean waitForKernelFinish = true;
    protected final CLKernelExecutor mCLKernelExecutor;
    public final NativeTypeEnum Float = NativeTypeEnum.Float;
    public final NativeTypeEnum UnsignedShort = NativeTypeEnum.UnsignedShort;
    public final NativeTypeEnum UnsignedByte = NativeTypeEnum.UnsignedByte;
    Stack<Long> times;
    StringBuilder timeTraces = new StringBuilder();

    @Override
    public CLIJ getCLIJ() {
        return this.clij;
    }

    @Override
    public CLIJ2 getCLIJ2() {
        return this;
    }

    @Deprecated
    public CLIJ2(CLIJ clij) {
        this.clij = clij;
        this.mCLKernelExecutor = new CLKernelExecutor(clij.getClearCLContext());
        this.max_num_bytes = clij.getClearCLContext().getDevice().getMaxMemoryAllocationSizeInBytes();
    }

    private static void checkInstallation() {
        try {
            String dir = IJ.getDirectory((String)"imagej");
            if (!dir.contains("null") && dir.toLowerCase().contains("fiji")) {
                File plugins_dir = new File(dir + "/plugins");
                if (CLIJ2.jarExists(plugins_dir, "clij2_") && !CLIJ2.jarExists(plugins_dir, "clij_")) {
                    System.out.println("CLIJ2 is not installed correctly. Please activate the 'clij' update site");
                }
                if (CLIJ2.jarExists(plugins_dir, "clijx-assistant-bonej") && !CLIJ2.jarExists(plugins_dir, "bonej-legacy")) {
                    System.out.println("CLIJx extension for BoneJ is not installed correctly. Please activate the 'BoneJ' update site");
                }
                if (CLIJ2.jarExists(plugins_dir, "clijx-assistant-morpholibj_") && !CLIJ2.jarExists(plugins_dir, "MorphoLibJ_")) {
                    System.out.println("CLIJx extension for MorpholibJ is not installed correctly. Please activate the 'IJPB-Plugins' update site");
                }
                if (CLIJ2.jarExists(plugins_dir, "clijx-assistant-imagej3dsuite_") && !CLIJ2.jarExists(plugins_dir, "mcib3d-suite")) {
                    System.out.println("CLIJx extension for the ImageJ 3D Suite is not installed correctly. Please activate the '3D ImageJ Suite' update site");
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error while checking the CLIJ2 installation:");
            System.out.println(e.getMessage());
        }
    }

    private static boolean jarExists(File folder, String name) {
        return folder.list((dir, name1) -> name1.contains(name)).length > 0;
    }

    public static CLIJ2 getInstance() {
        CLIJ clij = CLIJ.getInstance();
        if (instance == null || CLIJ2.instance.clij != CLIJ.getInstance()) {
            instance = new CLIJ2(clij);
        }
        return instance;
    }

    public static CLIJ2 getInstance(String id) {
        CLIJ clij = CLIJ.getInstance((String)id);
        if (instance == null || CLIJ2.instance.clij != clij) {
            instance = new CLIJ2(clij);
        }
        return instance;
    }

    public static String clinfo() {
        return CLIJ.clinfo();
    }

    public String getGPUName() {
        return this.clij.getGPUName();
    }

    public double getOpenCLVersion() {
        return this.clij.getOpenCLVersion();
    }

    public ClearCLBuffer push(Object object) {
        ClearCLBuffer buffer = (ClearCLBuffer)this.clij.convert(object, ClearCLBuffer.class);
        return buffer;
    }

    public ClearCLBuffer pushCurrentZStack(ImagePlus imp) {
        ClearCLBuffer buffer = this.clij.pushCurrentZStack(imp);
        return buffer;
    }

    public ClearCLBuffer pushCurrentSlice(ImagePlus imp) {
        ClearCLBuffer buffer = this.clij.pushCurrentSlice(imp);
        return buffer;
    }

    public ClearCLBuffer pushCurrentSelection(ImagePlus imp) {
        imp = new Duplicator().run(imp);
        ClearCLBuffer buffer = this.clij.pushCurrentSlice(imp);
        return buffer;
    }

    public ImagePlus pull(Object object) {
        return (ImagePlus)this.clij.convert(object, ImagePlus.class);
    }

    public RandomAccessibleInterval pullRAI(Object object) {
        return (RandomAccessibleInterval)this.clij.convert(object, RandomAccessibleInterval.class);
    }

    public RandomAccessibleInterval<BitType> pullBinaryRAI(Object object) {
        ClearCLBuffer buffer = this.convert(object, ClearCLBuffer.class);
        return this.clij.pullBinaryRAI(buffer);
    }

    public ClearCLBuffer pushMatXYZ(Object object) {
        if (object instanceof ClearCLBuffer) {
            return (ClearCLBuffer)object;
        }
        ClearCLBuffer result = null;
        if (object instanceof double[][][]) {
            Double3 double3 = new Double3((double[][][])object);
            Double3ToClearCLBufferConverter converter = new Double3ToClearCLBufferConverter();
            converter.setCLIJ(this.clij);
            result = converter.convert(double3);
        } else if (object instanceof double[][]) {
            Double2 double2 = new Double2((double[][])object);
            Double2ToClearCLBufferConverter converter = new Double2ToClearCLBufferConverter();
            converter.setCLIJ(this.clij);
            result = converter.convert(double2);
        } else if (object instanceof double[]) {
            Double1 double1 = new Double1((double[])object);
            Double1ToClearCLBufferConverter converter = new Double1ToClearCLBufferConverter();
            converter.setCLIJ(this.clij);
            result = converter.convert(double1);
        } else if (object instanceof float[][][]) {
            Float3 double3 = new Float3((float[][][])object);
            Float3ToClearCLBufferConverter converter = new Float3ToClearCLBufferConverter();
            converter.setCLIJ(this.clij);
            result = converter.convert(double3);
        } else if (object instanceof float[][]) {
            Float2 float2 = new Float2((float[][])object);
            Float2ToClearCLBufferConverter converter = new Float2ToClearCLBufferConverter();
            converter.setCLIJ(this.clij);
            result = converter.convert(float2);
        } else if (object instanceof float[]) {
            Float1 float1 = new Float1((float[])object);
            Float1ToClearCLBufferConverter converter = new Float1ToClearCLBufferConverter();
            converter.setCLIJ(this.clij);
            result = converter.convert(float1);
        } else if (object instanceof char[][][]) {
            Char3 char3 = new Char3((char[][][])object);
            Char3ToClearCLBufferConverter converter = new Char3ToClearCLBufferConverter();
            converter.setCLIJ(this.clij);
            result = converter.convert(char3);
        } else if (object instanceof char[][]) {
            Char2 char2 = new Char2((char[][])object);
            Char2ToClearCLBufferConverter converter = new Char2ToClearCLBufferConverter();
            converter.setCLIJ(this.clij);
            result = converter.convert(char2);
        } else if (object instanceof char[]) {
            Char1 char1 = new Char1((char[])object);
            Char1ToClearCLBufferConverter converter = new Char1ToClearCLBufferConverter();
            converter.setCLIJ(this.clij);
            result = converter.convert(char1);
        } else if (object instanceof byte[][][]) {
            Byte3 byte3 = new Byte3((byte[][][])object);
            Byte3ToClearCLBufferConverter converter = new Byte3ToClearCLBufferConverter();
            converter.setCLIJ(this.clij);
            result = converter.convert(byte3);
        } else if (object instanceof byte[][]) {
            Byte2 byte2 = new Byte2((byte[][])object);
            Byte2ToClearCLBufferConverter converter = new Byte2ToClearCLBufferConverter();
            converter.setCLIJ(this.clij);
            result = converter.convert(byte2);
        } else if (object instanceof byte[]) {
            Byte1 byte1 = new Byte1((byte[])object);
            Byte1ToClearCLBufferConverter converter = new Byte1ToClearCLBufferConverter();
            converter.setCLIJ(this.clij);
            result = converter.convert(byte1);
        } else {
            throw new IllegalArgumentException("Conversion of " + object + " / " + object.getClass().getName() + " not supported");
        }
        return result;
    }

    public ClearCLBuffer pushMat(Object object) {
        ClearCLBuffer result = this.pushMatXYZ(object);
        if (result.getDimension() != 3L) {
            ClearCLBuffer transposed = this.create(new long[]{result.getHeight(), result.getWidth()}, result.getNativeType());
            this.getCLIJ2().transposeXY(result, transposed);
            result.close();
            return transposed;
        }
        ClearCLBuffer transposed = this.create(new long[]{result.getDepth(), result.getHeight(), result.getWidth()}, result.getNativeType());
        this.getCLIJ2().transposeXZ(result, transposed);
        result.close();
        return transposed;
    }

    public Object pullMat(ClearCLBuffer input) {
        ClearCLBuffer buffer = input;
        if (buffer.getDimension() == 1L || buffer.getHeight() == 1L && buffer.getDepth() == 1L) {
            buffer = this.create(new long[]{input.getHeight(), input.getWidth()}, input.getNativeType());
            this.transposeXY(input, buffer);
        } else if (buffer.getDimension() == 2L || buffer.getDepth() == 1L) {
            buffer = this.create(new long[]{input.getHeight(), input.getWidth()}, input.getNativeType());
            this.transposeXY(input, buffer);
        } else if (buffer.getDimension() == 3L) {
            buffer = this.create(new long[]{input.getDepth(), input.getHeight(), input.getWidth()}, input.getNativeType());
            this.transposeXZ(input, buffer);
        }
        Object result = this.pullMatXYZ(buffer);
        buffer.close();
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object pullMatXYZ(ClearCLBuffer input) {
        void var3_16;
        ClearCLBuffer buffer = input;
        Object var3_3 = null;
        if (input.getNativeType() == NativeTypeEnum.Double) {
            if (buffer.getDimension() == 1L || buffer.getHeight() == 1L && buffer.getDepth() == 1L) {
                double[] dArray = new ClearCLBufferToDouble2Converter().convert((ClearCLBuffer)buffer).data[1];
                return var3_16;
            } else if (buffer.getDimension() == 2L || buffer.getDepth() == 1L) {
                double[][] dArray = new ClearCLBufferToDouble2Converter().convert((ClearCLBuffer)buffer).data;
                return var3_16;
            } else {
                if (buffer.getDimension() != 3L) throw new IllegalArgumentException("Conversion of " + buffer + " / " + buffer.getClass().getName() + " not supported");
                double[][][] dArray = new ClearCLBufferToDouble3Converter().convert((ClearCLBuffer)buffer).data;
            }
            return var3_16;
        } else if (input.getNativeType() == this.Float) {
            if (buffer.getDimension() == 1L || buffer.getHeight() == 1L && buffer.getDepth() == 1L) {
                float[] fArray = new ClearCLBufferToFloat2Converter().convert((ClearCLBuffer)buffer).data[1];
                return var3_16;
            } else if (buffer.getDimension() == 2L || buffer.getDepth() == 1L) {
                float[][] fArray = new ClearCLBufferToFloat2Converter().convert((ClearCLBuffer)buffer).data;
                return var3_16;
            } else {
                if (buffer.getDimension() != 3L) throw new IllegalArgumentException("Conversion of " + buffer + " / " + buffer.getClass().getName() + " not supported");
                float[][][] fArray = new ClearCLBufferToFloat3Converter().convert((ClearCLBuffer)buffer).data;
            }
            return var3_16;
        } else if (input.getNativeType() == this.UnsignedShort) {
            if (buffer.getDimension() == 1L || buffer.getHeight() == 1L && buffer.getDepth() == 1L) {
                char[] cArray = new ClearCLBufferToChar2Converter().convert((ClearCLBuffer)buffer).data[1];
                return var3_16;
            } else if (buffer.getDimension() == 2L || buffer.getDepth() == 1L) {
                char[][] cArray = new ClearCLBufferToChar2Converter().convert((ClearCLBuffer)buffer).data;
                return var3_16;
            } else {
                if (buffer.getDimension() != 3L) throw new IllegalArgumentException("Conversion of " + buffer + " / " + buffer.getClass().getName() + " not supported");
                char[][][] cArray = new ClearCLBufferToChar3Converter().convert((ClearCLBuffer)buffer).data;
            }
            return var3_16;
        } else {
            if (input.getNativeType() != this.UnsignedByte) return var3_16;
            if (buffer.getDimension() == 1L || buffer.getHeight() == 1L && buffer.getDepth() == 1L) {
                byte[] byArray = new ClearCLBufferToByte2Converter().convert((ClearCLBuffer)buffer).data[1];
                return var3_16;
            } else if (buffer.getDimension() == 2L || buffer.getDepth() == 1L) {
                byte[][] byArray = new ClearCLBufferToByte2Converter().convert((ClearCLBuffer)buffer).data;
                return var3_16;
            } else {
                if (buffer.getDimension() != 3L) throw new IllegalArgumentException("Conversion of " + buffer + " / " + buffer.getClass().getName() + " not supported");
                byte[][][] byArray = new ClearCLBufferToByte3Converter().convert((ClearCLBuffer)buffer).data;
            }
        }
        return var3_16;
    }

    public void pullToRAI(Object object, RandomAccessibleInterval target) {
        RandomAccessibleInterval rai = this.pullRAI(object);
        Cursor cursor = Views.iterable((RandomAccessibleInterval)rai).cursor();
        Cursor target_cursor = Views.iterable((RandomAccessibleInterval)target).cursor();
        while (cursor.hasNext() && target_cursor.hasNext()) {
            ((RealType)target_cursor.next()).set((Type)cursor.next());
        }
    }

    public void show(Object object, String title) {
        ImagePlus imp = (ImagePlus)this.clij.convert(object, ImagePlus.class);
        this.clij.show((Object)imp, title);
    }

    public <T> T convert(Object object, Class<T> klass) {
        return (T)this.clij.convert(object, klass);
    }

    public ClearCLBuffer create(ClearCLBuffer buffer) {
        ClearCLBuffer result = this.create(buffer.getDimensions(), buffer.getNativeType());
        return result;
    }

    public ClearCLImage create(ClearCLImage image) {
        ClearCLImage result = this.clij.create(image.getDimensions(), image.getChannelDataType());
        return result;
    }

    public ClearCLBuffer create(long dimensionX, long dimensionY, long dimensionZ) {
        return this.create(new long[]{dimensionX, dimensionY, dimensionZ}, NativeTypeEnum.Float);
    }

    public ClearCLBuffer create(long dimensionX, long dimensionY) {
        return this.create(new long[]{dimensionX, dimensionY}, NativeTypeEnum.Float);
    }

    public ClearCLBuffer create(long[] dimensions) {
        ClearCLBuffer buffer = this.create(dimensions, NativeTypeEnum.Float);
        return buffer;
    }

    public ClearCLBuffer create(double[] dblDimensions) {
        long[] dimensions = new long[dblDimensions.length];
        for (int i = 0; i < dimensions.length; ++i) {
            dimensions[i] = (long)dblDimensions[i];
        }
        return this.create(dimensions, NativeTypeEnum.Float);
    }

    public ClearCLBuffer create(long[] dimensions, NativeTypeEnum typeEnum) {
        this.checkMaxImageSize(dimensions, typeEnum.getSizeInBytes());
        try {
            return this.clij.create(dimensions, typeEnum);
        }
        catch (Exception e) {
            System.out.println(this.clij.humanReadableErrorMessage(e.getMessage()));
            throw e;
        }
    }

    public ClearCLImage create(long[] dimensions, ImageChannelDataType typeEnum) {
        this.checkMaxImageSize(dimensions, typeEnum.getNativeType().getSizeInBytes());
        try {
            return this.clij.create(dimensions, typeEnum);
        }
        catch (Exception e) {
            System.out.println(this.clij.humanReadableErrorMessage(e.getMessage()));
            throw e;
        }
    }

    private void checkMaxImageSize(long[] dimensions, long bytes_per_pixel) {
        long num_pixels = 1L;
        for (long dim : dimensions) {
            num_pixels *= dim;
        }
        long num_bytes = num_pixels * bytes_per_pixel;
        if (num_bytes > this.max_num_bytes) {
            this.warn("CLIJ2 Warning: You're creating an image with size " + this.humanReadableBytes(num_bytes) + ", which exceeds your GPUs capabilities (max " + this.humanReadableBytes(this.max_num_bytes) + ").");
        }
    }

    private String humanReadableBytes(double num_bytes) {
        if (num_bytes > 1024.0) {
            if ((num_bytes /= 1024.0) > 1024.0) {
                if ((num_bytes /= 1024.0) > 1024.0) {
                    if ((num_bytes /= 1024.0) > 1024.0) {
                        return "" + (double)((long)((num_bytes /= 1024.0) * 10.0)) / 10.0 + " terabytes";
                    }
                    return "" + (double)((long)(num_bytes * 10.0)) / 10.0 + " gigabytes";
                }
                return "" + (double)((long)(num_bytes * 10.0)) / 10.0 + " megabytes";
            }
            return "" + (double)((long)(num_bytes * 10.0)) / 10.0 + " kilobytes";
        }
        return "" + (double)((long)(num_bytes * 10.0)) / 10.0 + " bytes";
    }

    public void warn(String text) {
        System.out.println(text);
    }

    public void execute(String programFilename, String kernelname, long[] dimensions, long[] globalsizes, Map<String, Object> parameters, Map<String, Object> constants) {
        ClearCLKernel kernel = this.executeSubsequently(null, programFilename, kernelname, dimensions, globalsizes, parameters, constants, null);
        kernel.close();
    }

    public void execute(Class anchorClass, String programFilename, String kernelname, long[] dimensions, long[] globalsizes, Map<String, Object> parameters, Map<String, Object> constants) {
        ClearCLKernel kernel = this.executeSubsequently(anchorClass, programFilename, kernelname, dimensions, globalsizes, parameters, constants, null);
        kernel.close();
    }

    public void execute(Class anchorClass, String programFilename, String kernelname, long[] dimensions, long[] globalsizes, Map<String, Object> parameters) {
        ClearCLKernel kernel = this.executeSubsequently(anchorClass, programFilename, kernelname, dimensions, globalsizes, parameters, null);
        kernel.close();
    }

    public void execute(Class anchorClass, String programFilename, String kernelname, long[] dimensions, long[] globalsizes, long[] localSizes, Map<String, Object> parameters) {
        ClearCLKernel kernel = this.executeSubsequently(anchorClass, programFilename, kernelname, dimensions, globalsizes, localSizes, parameters, null, null);
        kernel.close();
    }

    public void execute(Class anchorClass, String programFilename, String kernelname, long[] dimensions, long[] globalsizes, long[] localSizes, Map<String, Object> parameters, Map<String, Object> constants) {
        ClearCLKernel kernel = this.executeSubsequently(anchorClass, programFilename, kernelname, dimensions, globalsizes, localSizes, parameters, constants, null);
        kernel.close();
    }

    public ClearCLKernel executeSubsequently(Class anchorClass, String pProgramFilename, String pKernelname, long[] dimensions, long[] globalsizes, Map<String, Object> parameters, ClearCLKernel kernel) {
        return this.executeSubsequently(anchorClass, pProgramFilename, pKernelname, dimensions, globalsizes, parameters, null, kernel);
    }

    public ClearCLKernel executeSubsequently(Class anchorClass, String pProgramFilename, String pKernelname, long[] dimensions, long[] globalsizes, Map<String, Object> parameters, Map<String, Object> constants, ClearCLKernel kernel) {
        return this.executeSubsequently(anchorClass, pProgramFilename, pKernelname, dimensions, globalsizes, null, parameters, constants, kernel);
    }

    public synchronized ClearCLKernel executeSubsequently(Class anchorClass, String pProgramFilename, String pKernelname, long[] dimensions, long[] globalsizes, long[] localSizes, Map<String, Object> parameters, Map<String, Object> constants, ClearCLKernel kernel) {
        ClearCLKernel[] result = new ClearCLKernel[]{kernel};
        if (CLIJ.debug) {
            for (String key : parameters.keySet()) {
                System.out.println(key + " = " + parameters.get(key));
            }
        }
        ElapsedTime.measure((String)("kernel + build " + pKernelname), () -> {
            this.mCLKernelExecutor.setProgramFilename(pProgramFilename);
            this.mCLKernelExecutor.setKernelName(pKernelname);
            this.mCLKernelExecutor.setAnchorClass(anchorClass);
            this.mCLKernelExecutor.setParameterMap(parameters);
            this.mCLKernelExecutor.setConstantsMap(constants);
            this.mCLKernelExecutor.setGlobalSizes(globalsizes);
            this.mCLKernelExecutor.setLocalSizes(localSizes);
            try {
                result[0] = this.mCLKernelExecutor.enqueue(this.waitForKernelFinish, kernel);
            }
            catch (Exception e) {
                System.out.println(this.clij.humanReadableErrorMessage(e.getMessage()));
                throw e;
            }
            this.mCLKernelExecutor.setImageSizeIndependentCompilation(false);
        });
        return result[0];
    }

    public void executeCode(String sourceCode, String kernelname, long[] dimensions, long[] globalsizes, Map<String, Object> parameters, Map<String, Object> constants) {
        ClearCLKernel kernel = this.executeCodeSubsequently(sourceCode, kernelname, dimensions, globalsizes, parameters, constants, null);
        kernel.close();
    }

    public void executeCode(String sourceCode, String kernelname, long[] dimensions, long[] globalsizes, Map<String, Object> parameters) {
        ClearCLKernel kernel = this.executeCodeSubsequently(sourceCode, kernelname, dimensions, globalsizes, parameters, null);
        kernel.close();
    }

    public void executeCode(String sourceCode, String kernelname, long[] dimensions, long[] globalsizes, long[] localSizes, Map<String, Object> parameters) {
        ClearCLKernel kernel = this.executeCodeSubsequently(sourceCode, kernelname, dimensions, globalsizes, localSizes, parameters, null, null);
        kernel.close();
    }

    public ClearCLKernel executeCodeSubsequently(String sourceCode, String pKernelname, long[] dimensions, long[] globalsizes, Map<String, Object> parameters, ClearCLKernel kernel) {
        return this.executeCodeSubsequently(sourceCode, pKernelname, dimensions, globalsizes, parameters, null, kernel);
    }

    public ClearCLKernel executeCodeSubsequently(String sourceCode, String pKernelname, long[] dimensions, long[] globalsizes, Map<String, Object> parameters, Map<String, Object> constants, ClearCLKernel kernel) {
        return this.executeCodeSubsequently(sourceCode, pKernelname, dimensions, globalsizes, null, parameters, constants, kernel);
    }

    public ClearCLKernel executeCodeSubsequently(String sourceCode, String pKernelname, long[] dimensions, long[] globalsizes, long[] localSizes, Map<String, Object> parameters, Map<String, Object> constants, ClearCLKernel kernel) {
        ClearCLKernel[] result = new ClearCLKernel[]{kernel};
        if (CLIJ.debug) {
            for (String key : parameters.keySet()) {
                System.out.println(key + " = " + parameters.get(key));
            }
        }
        ElapsedTime.measure((String)("kernel + build " + pKernelname), () -> {
            this.mCLKernelExecutor.setProgramSourceCode(sourceCode);
            this.mCLKernelExecutor.setKernelName(pKernelname);
            this.mCLKernelExecutor.setAnchorClass(Object.class);
            this.mCLKernelExecutor.setParameterMap(parameters);
            this.mCLKernelExecutor.setConstantsMap(constants);
            this.mCLKernelExecutor.setGlobalSizes(globalsizes);
            this.mCLKernelExecutor.setLocalSizes(localSizes);
            try {
                result[0] = this.mCLKernelExecutor.enqueue(this.waitForKernelFinish, kernel);
            }
            catch (Exception e) {
                System.out.println(this.clij.humanReadableErrorMessage(e.getMessage()));
                throw e;
            }
            this.mCLKernelExecutor.setImageSizeIndependentCompilation(false);
        });
        return result[0];
    }

    public boolean isSizeIndependentKernelCompilation() {
        return this.mCLKernelExecutor.isImageSizeIndependentCompilation();
    }

    public void activateSizeIndependentKernelCompilation() {
        this.mCLKernelExecutor.setImageSizeIndependentCompilation(true);
    }

    public void setWaitForKernelFinish(boolean waitForKernelFinish) {
        this.waitForKernelFinish = waitForKernelFinish;
    }

    @Deprecated
    public CLIJ getClij() {
        return this.clij;
    }

    @Deprecated
    public void setKeepReferences(boolean keepReferences) {
        System.out.println("CLIJ2.setKeepReferences is obsolete.");
    }

    public void release(ClearCLImageInterface image) {
        if (image != null) {
            image.close();
        }
    }

    public void clear() {
        this.getCLIJ().getClearCLContext().releaseImages();
    }

    public String reportMemory() {
        return this.getCLIJ().getClearCLContext().reportAboutAllocatedImages();
    }

    public void close() {
        this.clear();
        if (this == instance) {
            instance = null;
        }
        this.clij.close();
    }

    public CLIJ2 __enter__() {
        this.clear();
        return this;
    }

    public void __exit__(Object ... args) {
        this.clear();
    }

    public boolean hasImageSupport() {
        return this.clij.hasImageSupport();
    }

    public ImagePlus pullBinary(ClearCLBuffer input) {
        return this.clij.pullBinary(input);
    }

    public void invalidateKernelCahe() {
        this.mCLKernelExecutor.close();
    }

    public ClearCLBuffer transfer(ClearCLBuffer input) {
        ClearCLBuffer output = this.create(input);
        this.transferTo(input, output);
        return output;
    }

    public void transferTo(ClearCLBuffer input, ClearCLBuffer output) {
        ByteBuffer buffer = ByteBuffer.allocate((int)input.getSizeInBytes());
        input.writeTo((Buffer)buffer, true);
        output.readFrom((Buffer)buffer, true);
    }

    @Override
    public boolean doTimeTracing() {
        return this.doTimeTracing;
    }

    public void setDoTimeTracing(boolean doTimeTracing) {
        this.doTimeTracing = doTimeTracing;
        if (doTimeTracing) {
            this.resetTimeTraces();
            this.recordMethodStart("timeTracing");
        } else {
            this.recordMethodEnd("timeTracing");
        }
    }

    public String getTimeTraces() {
        return this.timeTraces.toString();
    }

    @Override
    public void recordMethodStart(String method) {
        for (int i = 0; i < this.times.size(); ++i) {
            this.timeTraces.append(" ");
        }
        this.timeTraces.append("> " + method + "\n");
        this.times.push(System.nanoTime());
    }

    @Override
    public void recordMethodEnd(String method) {
        int i;
        double duration = (double)(System.nanoTime() - this.times.pop()) / 1000000.0;
        int charCount = 0;
        for (i = 0; i < this.times.size(); ++i) {
            this.timeTraces.append(" ");
            ++charCount;
        }
        this.timeTraces.append("< " + method);
        for (i = charCount += method.length(); i < 30; ++i) {
            this.timeTraces.append(" ");
        }
        this.timeTraces.append("" + duration + " ms");
        this.timeTraces.append("\n");
    }

    public void resetTimeTraces() {
        this.timeTraces = new StringBuilder();
        this.times = new Stack();
    }

    static {
        CLIJ2.checkInstallation();
    }
}

