/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.converters.implementations;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.converters.AbstractCLIJConverter;
import net.haesleinhuepf.clij.converters.CLIJConverterPlugin;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij2.converters.helptypes.Byte2;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJConverterPlugin.class)
public class Byte2ToClearCLBufferConverter
extends AbstractCLIJConverter<Byte2, ClearCLBuffer> {
    public ClearCLBuffer convert(Byte2 source) {
        long[] dimensions = new long[]{source.data.length, source.data[0].length};
        int numberOfPixelsPerSlice = (int)(dimensions[0] * dimensions[1]);
        long numberOfPixels = numberOfPixelsPerSlice;
        ClearCLBuffer target = this.clij.createCLBuffer(dimensions, NativeTypeEnum.UnsignedByte);
        byte[] inputArray = new byte[(int)numberOfPixels];
        int count = 0;
        int y = 0;
        while ((long)y < dimensions[1]) {
            int x = 0;
            while ((long)x < dimensions[0]) {
                inputArray[count] = source.data[x][y];
                ++count;
                ++x;
            }
            ++y;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(inputArray);
        target.readFrom((Buffer)byteBuffer, true);
        return target;
    }

    public Class<Byte2> getSourceType() {
        return Byte2.class;
    }

    public Class<ClearCLBuffer> getTargetType() {
        return ClearCLBuffer.class;
    }
}

