/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.converters.implementations;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.converters.AbstractCLIJConverter;
import net.haesleinhuepf.clij.converters.CLIJConverterPlugin;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij2.converters.helptypes.Byte3;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJConverterPlugin.class)
public class Byte3ToClearCLBufferConverter
extends AbstractCLIJConverter<Byte3, ClearCLBuffer> {
    public ClearCLBuffer convert(Byte3 source) {
        long[] dimensions = new long[]{source.data.length, source.data[0].length, source.data[0][0].length};
        int numberOfPixelsPerSlice = (int)(dimensions[0] * dimensions[1]);
        long numberOfPixels = (long)numberOfPixelsPerSlice * dimensions[2];
        ClearCLBuffer target = this.clij.createCLBuffer(dimensions, NativeTypeEnum.UnsignedByte);
        byte[] inputArray = new byte[(int)numberOfPixels];
        int count = 0;
        int z = 0;
        while ((long)z < dimensions[2]) {
            int y = 0;
            while ((long)y < dimensions[1]) {
                int x = 0;
                while ((long)x < dimensions[0]) {
                    inputArray[count] = source.data[x][y][z];
                    ++count;
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(inputArray);
        target.readFrom((Buffer)byteBuffer, true);
        return target;
    }

    public Class<Byte3> getSourceType() {
        return Byte3.class;
    }

    public Class<ClearCLBuffer> getTargetType() {
        return ClearCLBuffer.class;
    }
}

