/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.converters.implementations;

import java.nio.Buffer;
import java.nio.CharBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.converters.AbstractCLIJConverter;
import net.haesleinhuepf.clij.converters.CLIJConverterPlugin;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij2.converters.helptypes.Char1;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJConverterPlugin.class)
public class Char1ToClearCLBufferConverter
extends AbstractCLIJConverter<Char1, ClearCLBuffer> {
    public ClearCLBuffer convert(Char1 source) {
        long[] dimensions = new long[]{source.data.length, 1L};
        int numberOfPixelsPerSlice = (int)(dimensions[0] * dimensions[1]);
        long numberOfPixels = numberOfPixelsPerSlice;
        ClearCLBuffer target = this.clij.createCLBuffer(dimensions, NativeTypeEnum.UnsignedShort);
        char[] inputArray = new char[(int)numberOfPixels];
        int count = 0;
        int x = 0;
        while ((long)x < dimensions[0]) {
            inputArray[count] = source.data[x];
            ++count;
            ++x;
        }
        CharBuffer charBuffer = CharBuffer.wrap(inputArray);
        target.readFrom((Buffer)charBuffer, true);
        return target;
    }

    public Class<Char1> getSourceType() {
        return Char1.class;
    }

    public Class<ClearCLBuffer> getTargetType() {
        return ClearCLBuffer.class;
    }
}

