/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.converters.implementations;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.converters.AbstractCLIJConverter;
import net.haesleinhuepf.clij.converters.CLIJConverterPlugin;
import net.haesleinhuepf.clij2.converters.helptypes.Byte2;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJConverterPlugin.class)
public class ClearCLBufferToByte2Converter
extends AbstractCLIJConverter<ClearCLBuffer, Byte2> {
    public Byte2 convert(ClearCLBuffer source) {
        Byte2 target = new Byte2(new byte[(int)source.getWidth()][(int)source.getHeight()]);
        byte[] array = new byte[(int)(source.getWidth() * source.getHeight())];
        ByteBuffer buffer = ByteBuffer.wrap(array);
        source.writeTo((Buffer)buffer, true);
        int count = 0;
        for (int y = 0; y < target.data[0].length; ++y) {
            for (int x = 0; x < target.data.length; ++x) {
                target.data[x][y] = array[count];
                ++count;
            }
        }
        return target;
    }

    public Class<Byte2> getTargetType() {
        return Byte2.class;
    }

    public Class<ClearCLBuffer> getSourceType() {
        return ClearCLBuffer.class;
    }
}

