/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.converters.implementations;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.converters.AbstractCLIJConverter;
import net.haesleinhuepf.clij.converters.CLIJConverterPlugin;
import net.haesleinhuepf.clij2.converters.helptypes.Double2;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJConverterPlugin.class)
public class ClearCLBufferToDouble2Converter
extends AbstractCLIJConverter<ClearCLBuffer, Double2> {
    public Double2 convert(ClearCLBuffer source) {
        Double2 target = new Double2(new double[(int)source.getWidth()][(int)source.getHeight()]);
        float[] array = new float[(int)(source.getWidth() * source.getHeight())];
        FloatBuffer buffer = FloatBuffer.wrap(array);
        source.writeTo((Buffer)buffer, true);
        int count = 0;
        for (int y = 0; y < target.data[0].length; ++y) {
            for (int x = 0; x < target.data.length; ++x) {
                target.data[x][y] = array[count];
                ++count;
            }
        }
        return target;
    }

    public Class<Double2> getTargetType() {
        return Double2.class;
    }

    public Class<ClearCLBuffer> getSourceType() {
        return ClearCLBuffer.class;
    }
}

