/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.converters.implementations;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.converters.AbstractCLIJConverter;
import net.haesleinhuepf.clij.converters.CLIJConverterPlugin;
import net.haesleinhuepf.clij2.converters.helptypes.Float2;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJConverterPlugin.class)
public class ClearCLBufferToFloat2Converter
extends AbstractCLIJConverter<ClearCLBuffer, Float2> {
    public Float2 convert(ClearCLBuffer source) {
        Float2 target = new Float2(new float[(int)source.getWidth()][(int)source.getHeight()]);
        float[] array = new float[(int)(source.getWidth() * source.getHeight())];
        FloatBuffer buffer = FloatBuffer.wrap(array);
        source.writeTo((Buffer)buffer, true);
        int count = 0;
        for (int y = 0; y < target.data[0].length; ++y) {
            for (int x = 0; x < target.data.length; ++x) {
                target.data[x][y] = array[count];
                ++count;
            }
        }
        return target;
    }

    public Class<Float2> getTargetType() {
        return Float2.class;
    }

    public Class<ClearCLBuffer> getSourceType() {
        return ClearCLBuffer.class;
    }
}

