/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.converters.implementations;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.converters.AbstractCLIJConverter;
import net.haesleinhuepf.clij.converters.CLIJConverterPlugin;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij2.converters.helptypes.Float2;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJConverterPlugin.class)
public class Float2ToClearCLBufferConverter
extends AbstractCLIJConverter<Float2, ClearCLBuffer> {
    public ClearCLBuffer convert(Float2 source) {
        long[] dimensions = new long[]{source.data.length, source.data[0].length};
        int numberOfPixelsPerSlice = (int)(dimensions[0] * dimensions[1]);
        long numberOfPixels = numberOfPixelsPerSlice;
        ClearCLBuffer target = this.clij.createCLBuffer(dimensions, NativeTypeEnum.Float);
        float[] inputArray = new float[(int)numberOfPixels];
        int count = 0;
        int y = 0;
        while ((long)y < dimensions[1]) {
            int x = 0;
            while ((long)x < dimensions[0]) {
                inputArray[count] = source.data[x][y];
                ++count;
                ++x;
            }
            ++y;
        }
        FloatBuffer byteBuffer = FloatBuffer.wrap(inputArray);
        target.readFrom((Buffer)byteBuffer, true);
        return target;
    }

    public Class<Float2> getSourceType() {
        return Float2.class;
    }

    public Class<ClearCLBuffer> getTargetType() {
        return ClearCLBuffer.class;
    }
}

