/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.legacy;

import ij.IJ;
import ij.gui.GenericDialog;
import ij.macro.ExtensionDescriptor;
import ij.macro.Functions;
import ij.macro.MacroExtension;
import ij.plugin.PlugIn;
import java.util.ArrayList;
import java.util.Arrays;
import net.haesleinhuepf.clij.CLIJ;
import net.haesleinhuepf.clij.converters.CLIJConverterService;
import net.haesleinhuepf.clij.converters.FallBackCLIJConverterService;
import net.haesleinhuepf.clij.macro.CLIJHandler;
import net.haesleinhuepf.clij.macro.CLIJMacroPluginService;
import net.haesleinhuepf.clij2.legacy.FallBackCLIJMacroPluginService;

public class CLIJLegacyMacroExtensions
implements PlugIn {
    private static boolean warnedOutdatedOpenCLVersion = false;

    public void run(String s) {
        ArrayList deviceList = CLIJ.getAvailableDeviceNames();
        String[] deviceArray = new String[deviceList.size()];
        deviceList.toArray(deviceArray);
        GenericDialog gd = new GenericDialog("CLIJ");
        gd.addChoice("CL_Device", deviceArray, deviceArray[0]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        CLIJ clij = CLIJ.getInstance((String)gd.getNextChoice());
        CLIJHandler.automaticOutputVariableNaming = true;
        CLIJHandler.getInstance().setPluginService((CLIJMacroPluginService)new FallBackCLIJMacroPluginService());
        System.out.println("output naming " + CLIJHandler.automaticOutputVariableNaming);
        ExtensionDescriptor ed = CLIJHandler.getInstance().getPluginService().getPluginExtensionDescriptor("CLIJ2_gaussianBlur2D");
        System.out.println("Argtypes: " + Arrays.toString(ed.argTypes));
        System.out.println("output naming " + CLIJHandler.automaticOutputVariableNaming);
        FallBackCLIJConverterService clijConverterService = FallBackCLIJConverterService.getInstance();
        clijConverterService.setCLIJ(clij);
        clij.setConverterService((CLIJConverterService)clijConverterService);
        if (!warnedOutdatedOpenCLVersion && clij.getOpenCLVersion() < 1.2) {
            IJ.log((String)"Warning: Your GPU does not support OpenCL 1.2. Some operations may not work precisely. For example: CLIJ does not support linear interpolation; it uses nearest-neighbor interpolation instead. Consider upgrading GPU Driver version or GPU hardware.");
            warnedOutdatedOpenCLVersion = true;
        }
        if (!IJ.macroRunning()) {
            IJ.error((String)"Cannot install extensions from outside a macro.");
            return;
        }
        Functions.registerExtensions((MacroExtension)CLIJHandler.getInstance());
    }
}

