/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.plugins.AddImagesWeighted;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import net.haesleinhuepf.clij2.utilities.ProcessableInTiles;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_addImages")
public class AddImages
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
ProcessableInTiles,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Math";
    }

    public boolean executeCL() {
        return this.getCLIJ2().addImages((ClearCLImageInterface)this.args[0], (ClearCLImageInterface)this.args[1], (ClearCLImageInterface)this.args[2]);
    }

    public static boolean addImages(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface src1, ClearCLImageInterface dst) {
        return AddImagesWeighted.addImagesWeighted(clij2, src, src1, dst, Float.valueOf(1.0f), Float.valueOf(1.0f));
    }

    public String getParameterHelpText() {
        return "Image summand1, Image summand2, ByRef Image destination";
    }

    public String getDescription() {
        return "Calculates the sum of pairs of pixels x and y of two images X and Y.\n\n<pre>f(x, y) = x + y</pre>\n\nParameters\n----------\nsummand1 : Image\n    The first input image to added.\nsummand2 : Image\n    The second image to be added.\ndestination : Image\n    The output image where results are written into.\n";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

