/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_addImagesWeighted")
public class AddImagesWeighted
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Math";
    }

    public Object[] getDefaultValues() {
        return new Object[]{null, null, null, 1.0, 1.0};
    }

    public boolean executeCL() {
        return this.getCLIJ2().addImagesWeighted((ClearCLImageInterface)this.args[0], (ClearCLImageInterface)this.args[1], (ClearCLImageInterface)this.args[2], AddImagesWeighted.asFloat((Object)this.args[3]).floatValue(), AddImagesWeighted.asFloat((Object)this.args[4]).floatValue());
    }

    public static boolean addImagesWeighted(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface src1, ClearCLImageInterface dst, Float factor, Float factor1) {
        net.haesleinhuepf.clij.utilities.CLIJUtilities.assertDifferent((Object)src, (Object)dst);
        net.haesleinhuepf.clij.utilities.CLIJUtilities.assertDifferent((Object)src1, (Object)dst);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src", src);
        parameters.put("src1", src1);
        parameters.put("factor", factor);
        parameters.put("factor1", factor1);
        parameters.put("dst", dst);
        if (!CLIJUtilities.checkDimensions(src.getDimension(), src1.getDimension(), dst.getDimension())) {
            throw new IllegalArgumentException("Error: number of dimensions don't match! (addImageAndScalar)");
        }
        clij2.execute(AddImagesWeighted.class, "add_images_weighted_" + src.getDimension() + "d_x.cl", "add_images_weighted_" + src.getDimension() + "d", dst.getDimensions(), dst.getDimensions(), parameters);
        return true;
    }

    public String getParameterHelpText() {
        return "Image summand1, Image summand2, ByRef Image destination, Number factor1, Number factor2";
    }

    public String getDescription() {
        return "Calculates the sum of pairs of pixels x and y from images X and Y weighted with factors a and b.\n\n<pre>f(x, y, a, b) = x * a + y * b</pre>\n\nParameters\n----------\nsummand1 : Image\n    The first input image to added.\nsummand2 : Image\n    The second image to be added.\ndestination : Image\n    The output image where results are written into.\nfactor1 : float\n    The constant number which will be multiplied with each pixel of summand1 before adding it.\nfactor2 : float\n    The constant number which will be multiplied with each pixel of summand2 before adding it.\n";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

