/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLImage;
import net.haesleinhuepf.clij.clearcl.enums.ImageChannelDataType;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij.utilities.AffineTransform;
import net.haesleinhuepf.clij.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasAuthor;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.HasLicense;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_affineTransform3D")
public class AffineTransform3D
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
HasAuthor,
HasLicense,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public boolean executeCL() {
        ClearCLBuffer input = (ClearCLBuffer)this.args[0];
        ClearCLBuffer output = (ClearCLBuffer)this.args[1];
        String transform = (String)this.args[2];
        return this.getCLIJ2().affineTransform3D(input, (ClearCLImageInterface)output, transform);
    }

    public static boolean affineTransform3D(CLIJ2 clij2, ClearCLBuffer input, ClearCLImageInterface output, String transform) {
        String[] transformCommands = transform.trim().toLowerCase().split(" ");
        net.imglib2.realtransform.AffineTransform3D at = new net.imglib2.realtransform.AffineTransform3D();
        for (String transformCommand : transformCommands) {
            net.imglib2.realtransform.AffineTransform3D shearTransform;
            float angle;
            String[] commandParts = transformCommand.split("=");
            if (commandParts[0].compareTo("center") == 0) {
                net.imglib2.realtransform.AffineTransform3D translateTransform = new net.imglib2.realtransform.AffineTransform3D();
                translateTransform.translate(new double[]{-input.getWidth() / 2L, -input.getHeight() / 2L, -input.getDepth() / 2L});
                at.concatenate(translateTransform);
                continue;
            }
            if (commandParts[0].compareTo("-center") == 0) {
                net.imglib2.realtransform.AffineTransform3D translateTransform = new net.imglib2.realtransform.AffineTransform3D();
                translateTransform.translate(new double[]{input.getWidth() / 2L, input.getHeight() / 2L, input.getDepth() / 2L});
                at.concatenate(translateTransform);
                continue;
            }
            if (commandParts[0].compareTo("scale") == 0) {
                net.imglib2.realtransform.AffineTransform3D scaleTransform = new net.imglib2.realtransform.AffineTransform3D();
                scaleTransform.scale(1.0 / Double.parseDouble(commandParts[1]));
                at.concatenate(scaleTransform);
                continue;
            }
            if (commandParts[0].compareTo("scalex") == 0) {
                net.imglib2.realtransform.AffineTransform3D scaleTransform = new net.imglib2.realtransform.AffineTransform3D();
                scaleTransform.set(1.0 / Double.parseDouble(commandParts[1]), 0, 0);
                scaleTransform.set(1.0, 1, 1);
                scaleTransform.set(1.0, 2, 2);
                at.concatenate(scaleTransform);
                continue;
            }
            if (commandParts[0].compareTo("scaley") == 0) {
                net.imglib2.realtransform.AffineTransform3D scaleTransform = new net.imglib2.realtransform.AffineTransform3D();
                scaleTransform.set(1.0, 0, 0);
                scaleTransform.set(1.0 / Double.parseDouble(commandParts[1]), 1, 1);
                scaleTransform.set(1.0, 2, 2);
                at.concatenate(scaleTransform);
                continue;
            }
            if (commandParts[0].compareTo("scalez") == 0) {
                net.imglib2.realtransform.AffineTransform3D scaleTransform = new net.imglib2.realtransform.AffineTransform3D();
                scaleTransform.set(1.0, 0, 0);
                scaleTransform.set(1.0, 1, 1);
                scaleTransform.set(1.0 / Double.parseDouble(commandParts[1]), 2, 2);
                at.concatenate(scaleTransform);
                continue;
            }
            if (commandParts[0].compareTo("rotatex") == 0) {
                net.imglib2.realtransform.AffineTransform3D rotateTransform = new net.imglib2.realtransform.AffineTransform3D();
                angle = (float)((double)(-AffineTransform3D.asFloat((Object)commandParts[1]).floatValue() / 180.0f) * Math.PI);
                rotateTransform.rotate(0, (double)angle);
                at.concatenate(rotateTransform);
                continue;
            }
            if (commandParts[0].compareTo("rotatey") == 0) {
                net.imglib2.realtransform.AffineTransform3D rotateTransform = new net.imglib2.realtransform.AffineTransform3D();
                angle = (float)((double)(-AffineTransform3D.asFloat((Object)commandParts[1]).floatValue() / 180.0f) * Math.PI);
                rotateTransform.rotate(1, (double)angle);
                at.concatenate(rotateTransform);
                continue;
            }
            if (commandParts[0].compareTo("rotatez") == 0 || commandParts[0].compareTo("rotate") == 0) {
                net.imglib2.realtransform.AffineTransform3D rotateTransform = new net.imglib2.realtransform.AffineTransform3D();
                angle = (float)((double)(-AffineTransform3D.asFloat((Object)commandParts[1]).floatValue() / 180.0f) * Math.PI);
                rotateTransform.rotate(2, (double)angle);
                at.concatenate(rotateTransform);
                continue;
            }
            if (commandParts[0].compareTo("translatex") == 0) {
                net.imglib2.realtransform.AffineTransform3D translateTransform = new net.imglib2.realtransform.AffineTransform3D();
                translateTransform.translate(new double[]{Double.parseDouble(commandParts[1]), 0.0, 0.0});
                at.concatenate(translateTransform);
                continue;
            }
            if (commandParts[0].compareTo("translatey") == 0) {
                net.imglib2.realtransform.AffineTransform3D translateTransform = new net.imglib2.realtransform.AffineTransform3D();
                translateTransform.translate(new double[]{0.0, Double.parseDouble(commandParts[1]), 0.0});
                at.concatenate(translateTransform);
                continue;
            }
            if (commandParts[0].compareTo("translatez") == 0) {
                net.imglib2.realtransform.AffineTransform3D translateTransform = new net.imglib2.realtransform.AffineTransform3D();
                translateTransform.translate(new double[]{0.0, 0.0, Double.parseDouble(commandParts[1])});
                at.concatenate(translateTransform);
                continue;
            }
            if (commandParts[0].compareTo("shearxy") == 0) {
                double shear = Double.parseDouble(commandParts[1]);
                shearTransform = new net.imglib2.realtransform.AffineTransform3D();
                shearTransform.set(1.0, 0, 0);
                shearTransform.set(1.0, 1, 1);
                shearTransform.set(1.0, 2, 2);
                shearTransform.set(shear, 0, 1);
                at.concatenate(shearTransform);
                continue;
            }
            if (commandParts[0].compareTo("shearxz") == 0) {
                double shear = Double.parseDouble(commandParts[1]);
                shearTransform = new net.imglib2.realtransform.AffineTransform3D();
                shearTransform.set(1.0, 0, 0);
                shearTransform.set(1.0, 1, 1);
                shearTransform.set(1.0, 2, 2);
                shearTransform.set(shear, 0, 2);
                at.concatenate(shearTransform);
                continue;
            }
            if (commandParts[0].compareTo("shearyx") == 0) {
                double shear = Double.parseDouble(commandParts[1]);
                shearTransform = new net.imglib2.realtransform.AffineTransform3D();
                shearTransform.set(1.0, 0, 0);
                shearTransform.set(1.0, 1, 1);
                shearTransform.set(1.0, 2, 2);
                shearTransform.set(shear, 1, 0);
                at.concatenate(shearTransform);
                continue;
            }
            if (commandParts[0].compareTo("shearyz") == 0) {
                double shear = Double.parseDouble(commandParts[1]);
                shearTransform = new net.imglib2.realtransform.AffineTransform3D();
                shearTransform.set(1.0, 0, 0);
                shearTransform.set(1.0, 1, 1);
                shearTransform.set(1.0, 2, 2);
                shearTransform.set(shear, 1, 2);
                at.concatenate(shearTransform);
                continue;
            }
            if (commandParts[0].compareTo("shearzx") == 0) {
                double shear = Double.parseDouble(commandParts[1]);
                shearTransform = new net.imglib2.realtransform.AffineTransform3D();
                shearTransform.set(1.0, 0, 0);
                shearTransform.set(1.0, 1, 1);
                shearTransform.set(1.0, 2, 2);
                shearTransform.set(shear, 2, 0);
                at.concatenate(shearTransform);
                continue;
            }
            if (commandParts[0].compareTo("shearzy") == 0) {
                double shear = Double.parseDouble(commandParts[1]);
                shearTransform = new net.imglib2.realtransform.AffineTransform3D();
                shearTransform.set(1.0, 0, 0);
                shearTransform.set(1.0, 1, 1);
                shearTransform.set(1.0, 2, 2);
                shearTransform.set(shear, 2, 1);
                at.concatenate(shearTransform);
                continue;
            }
            System.out.print("Unknown transform: " + commandParts[0]);
        }
        if (!clij2.hasImageSupport()) {
            return AffineTransform3D.affineTransform3D(clij2, input, output, AffineTransform.matrixToFloatArray((net.imglib2.realtransform.AffineTransform3D)at));
        }
        ClearCLImage inputImage = clij2.create(input.getDimensions(), ImageChannelDataType.Float);
        clij2.copy((ClearCLImageInterface)input, (ClearCLImageInterface)inputImage);
        boolean result = AffineTransform3D.affineTransform3D(clij2, inputImage, output, AffineTransform.matrixToFloatArray((net.imglib2.realtransform.AffineTransform3D)at));
        clij2.release((ClearCLImageInterface)inputImage);
        return result;
    }

    public static boolean affineTransform3D(CLIJ2 clij2, ClearCLBuffer src, ClearCLImageInterface dst, float[] matrix) {
        CLIJUtilities.assertDifferent((Object)src, (Object)dst);
        ClearCLBuffer matrixCl = clij2.create(new long[]{matrix.length, 1L, 1L}, NativeTypeEnum.Float);
        FloatBuffer buffer = FloatBuffer.wrap(matrix);
        matrixCl.readFrom((Buffer)buffer, true);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("input", src);
        parameters.put("output", dst);
        parameters.put("mat", matrixCl);
        clij2.execute(AffineTransform3D.class, "affine_transform_3d_x.cl", "affine_transform_3d", dst.getDimensions(), dst.getDimensions(), parameters);
        matrixCl.close();
        return true;
    }

    public static boolean affineTransform3D(CLIJ2 clij2, ClearCLBuffer src, ClearCLImageInterface dst, net.imglib2.realtransform.AffineTransform3D at) {
        CLIJUtilities.assertDifferent((Object)src, (Object)dst);
        float[] matrix = AffineTransform.matrixToFloatArray((net.imglib2.realtransform.AffineTransform3D)at);
        return AffineTransform3D.affineTransform3D(clij2, src, dst, matrix);
    }

    public static boolean affineTransform3D(CLIJ2 clij2, ClearCLImage src, ClearCLImageInterface dst, float[] matrix) {
        CLIJUtilities.assertDifferent((Object)src, (Object)dst);
        ClearCLBuffer matrixCl = clij2.create(new long[]{matrix.length, 1L, 1L}, NativeTypeEnum.Float);
        FloatBuffer buffer = FloatBuffer.wrap(matrix);
        matrixCl.readFrom((Buffer)buffer, true);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("input", src);
        parameters.put("output", dst);
        parameters.put("mat", matrixCl);
        clij2.execute(AffineTransform3D.class, "affine_transform_3d_interpolate_x.cl", "affine_transform_3d_interpolate", dst.getDimensions(), dst.getDimensions(), parameters);
        matrixCl.close();
        return true;
    }

    public static boolean affineTransform3D(CLIJ2 clij2, ClearCLImage src, ClearCLImageInterface dst, net.imglib2.realtransform.AffineTransform3D at) {
        CLIJUtilities.assertDifferent((Object)src, (Object)dst);
        float[] matrix = AffineTransform.matrixToFloatArray((net.imglib2.realtransform.AffineTransform3D)at);
        return AffineTransform3D.affineTransform3D(clij2, src, dst, matrix);
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination, String transform";
    }

    public String getDescription() {
        return "Applies an affine transform to a 3D image.\n\nThe transform describes how coordinates in the target image are transformed to coordinates in the source image.\nThis may appear unintuitive and will be changed in the next major release. The replacement \naffineTransform (currently part of CLIJx) will apply inverted transforms compared to this operation.\nIndividual transforms must be separated by spaces.\nParameters\n----------\nsource : Image\n    The input image to be processed.\ndestination : Image\n    The output image where results are written into.\ntransform : String\n    A space-separated list of individual transforms. Syntrax see below.\n\nSupported transforms:\n\n* -center: translate the coordinate origin to the center of the image\n* center: translate the coordinate origin back to the initial origin\n* rotate=[angle]: rotate in X/Y plane (around Z-axis) by the given angle in degrees\n* rotateX=[angle]: rotate in Y/Z plane (around X-axis) by the given angle in degrees\n* rotateY=[angle]: rotate in X/Z plane (around Y-axis) by the given angle in degrees\n* rotateZ=[angle]: rotate in X/Y plane (around Z-axis) by the given angle in degrees\n* scale=[factor]: isotropic scaling according to given zoom factor\n* scaleX=[factor]: scaling along X-axis according to given zoom factor\n* scaleY=[factor]: scaling along Y-axis according to given zoom factor\n* scaleZ=[factor]: scaling along Z-axis according to given zoom factor\n* shearXY=[factor]: shearing along X-axis in XY plane according to given factor\n* shearXZ=[factor]: shearing along X-axis in XZ plane according to given factor\n* shearYX=[factor]: shearing along Y-axis in XY plane according to given factor\n* shearYZ=[factor]: shearing along Y-axis in YZ plane according to given factor\n* shearZX=[factor]: shearing along Z-axis in XZ plane according to given factor\n* shearZY=[factor]: shearing along Z-axis in YZ plane according to given factor\n* translateX=[distance]: translate along X-axis by distance given in pixels\n* translateY=[distance]: translate along X-axis by distance given in pixels\n* translateZ=[distance]: translate along X-axis by distance given in pixels\n\nExample transform:\ntransform = \"-center scale=2 rotate=45 center\";";
    }

    public String getAvailableForDimensions() {
        return "3D";
    }

    public String getAuthorName() {
        return "Robert Haase based on work by Martin Weigert";
    }

    public String getLicense() {
        return " adapted from: https://github.com/maweigert/gputools/blob/master/gputools/transforms/kernels/transformations.cl\n\n Copyright (c) 2016, Martin Weigert\n All rights reserved.\n\n Redistribution and use in source and binary forms, with or without\n modification, are permitted provided that the following conditions are met:\n\n * Redistributions of source code must retain the above copyright notice, this\n   list of conditions and the following disclaimer.\n\n * Redistributions in binary form must reproduce the above copyright notice,\n   this list of conditions and the following disclaimer in the documentation\n   and/or other materials provided with the distribution.\n\n * Neither the name of gputools nor the names of its\n   contributors may be used to endorse or promote products derived from\n   this software without specific prior written permission.\n\n THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\"\n AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE\n IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE\n DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE\n FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL\n DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR\n SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER\n CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,\n OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
    }

    public String getCategories() {
        return "Transform";
    }
}

