/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLImage;
import net.haesleinhuepf.clij.clearcl.enums.ImageChannelDataType;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_applyVectorField2D")
public class ApplyVectorField2D
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public boolean executeCL() {
        if (this.clij.hasImageSupport()) {
            ClearCLBuffer inputBuffer = (ClearCLBuffer)this.args[0];
            ClearCLImage input = this.getCLIJ2().create(inputBuffer.getDimensions(), ImageChannelDataType.Float);
            this.getCLIJ2().copy((ClearCLImageInterface)inputBuffer, (ClearCLImageInterface)input);
            this.getCLIJ2().applyVectorField((ClearCLImageInterface)input, (ClearCLImageInterface)((ClearCLBuffer)this.args[1]), (ClearCLImageInterface)((ClearCLBuffer)this.args[2]), (ClearCLImageInterface)((ClearCLBuffer)this.args[3]));
            this.getCLIJ2().release((ClearCLImageInterface)input);
        } else {
            this.getCLIJ2().applyVectorField((ClearCLImageInterface)((ClearCLBuffer)this.args[0]), (ClearCLImageInterface)((ClearCLBuffer)this.args[1]), (ClearCLImageInterface)((ClearCLBuffer)this.args[2]), (ClearCLImageInterface)((ClearCLBuffer)this.args[3]));
        }
        return true;
    }

    public static boolean applyVectorField2D(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface vectorX, ClearCLImageInterface vectorY, ClearCLImageInterface dst) {
        return ApplyVectorField2D.applyVectorField(clij2, src, vectorX, vectorY, dst);
    }

    public static boolean applyVectorField(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface vector_x, ClearCLImageInterface vector_y, ClearCLImageInterface dst) {
        CLIJUtilities.assertDifferent((Object)src, (Object)dst);
        CLIJUtilities.assertDifferent((Object)vector_x, (Object)dst);
        CLIJUtilities.assertDifferent((Object)vector_y, (Object)dst);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src", src);
        parameters.put("dst", dst);
        parameters.put("vectorX", vector_x);
        parameters.put("vectorY", vector_y);
        if (src instanceof ClearCLImage) {
            clij2.execute(ApplyVectorField2D.class, "apply_vectorfield_2d_interpolate_x.cl", "apply_vectorfield_2d_interpolate", src.getDimensions(), src.getDimensions(), parameters);
        } else {
            clij2.execute(ApplyVectorField2D.class, "apply_vectorfield_2d_x.cl", "apply_vectorfield_2d", src.getDimensions(), src.getDimensions(), parameters);
        }
        return true;
    }

    public String getParameterHelpText() {
        return "Image source, Image vector_x, Image vector_y, ByRef Image destination";
    }

    public String getDescription() {
        return "Deforms an image according to distances provided in the given vector images.\n\n It is recommended to use 32-bit images for input, output and vector images.\n\nParameters\n----------\nsource : Image\n    The input image to be processed.\nvector_x : Image\n    Pixels in this image describe the distance in X direction pixels should be shifted during warping.\nvector_y : Image\n    Pixels in this image describe the distance in Y direction pixels should be shifted during warping.\ndestination : Image\n    The output image where results are written into.\n";
    }

    public String getAvailableForDimensions() {
        return "2D";
    }

    public String getCategories() {
        return "Transform";
    }
}

