/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLImage;
import net.haesleinhuepf.clij.clearcl.enums.ImageChannelDataType;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_applyVectorField3D")
public class ApplyVectorField3D
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public boolean executeCL() {
        if (this.clij.hasImageSupport()) {
            ClearCLBuffer inputBuffer = (ClearCLBuffer)this.args[0];
            ClearCLImage input = this.getCLIJ2().create(inputBuffer.getDimensions(), ImageChannelDataType.Float);
            this.getCLIJ2().copy((ClearCLImageInterface)inputBuffer, (ClearCLImageInterface)input);
            this.getCLIJ2().applyVectorField((ClearCLImageInterface)input, (ClearCLImageInterface)((ClearCLBuffer)this.args[1]), (ClearCLImageInterface)((ClearCLBuffer)this.args[2]), (ClearCLImageInterface)((ClearCLBuffer)this.args[3]), (ClearCLImageInterface)((ClearCLBuffer)this.args[4]));
            this.getCLIJ2().release((ClearCLImageInterface)input);
        } else {
            this.getCLIJ2().applyVectorField((ClearCLImageInterface)((ClearCLBuffer)this.args[0]), (ClearCLImageInterface)((ClearCLBuffer)this.args[1]), (ClearCLImageInterface)((ClearCLBuffer)this.args[2]), (ClearCLImageInterface)((ClearCLBuffer)this.args[3]), (ClearCLImageInterface)((ClearCLBuffer)this.args[4]));
        }
        return true;
    }

    public static boolean applyVectorField3D(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface vectorX, ClearCLImageInterface vectorY, ClearCLImageInterface vectorZ, ClearCLImageInterface dst) {
        return ApplyVectorField3D.applyVectorField(clij2, src, vectorX, vectorY, vectorZ, dst);
    }

    public static boolean applyVectorField(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface vectorX, ClearCLImageInterface vectorY, ClearCLImageInterface vectorZ, ClearCLImageInterface dst) {
        CLIJUtilities.assertDifferent((Object)src, (Object)dst);
        CLIJUtilities.assertDifferent((Object)vectorX, (Object)dst);
        CLIJUtilities.assertDifferent((Object)vectorY, (Object)dst);
        CLIJUtilities.assertDifferent((Object)vectorZ, (Object)dst);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src", src);
        parameters.put("dst", dst);
        parameters.put("vectorX", vectorX);
        parameters.put("vectorY", vectorY);
        parameters.put("vectorZ", vectorZ);
        if (src instanceof ClearCLImage) {
            clij2.execute(ApplyVectorField3D.class, "apply_vectorfield_3d_interpolate_x.cl", "apply_vectorfield_3d_interpolate", src.getDimensions(), src.getDimensions(), parameters);
        } else {
            clij2.execute(ApplyVectorField3D.class, "apply_vectorfield_3d_x.cl", "apply_vectorfield_3d", src.getDimensions(), src.getDimensions(), parameters);
        }
        return true;
    }

    public String getParameterHelpText() {
        return "Image source, Image vectorX, Image vectorY, Image vectorZ, ByRef Image destination";
    }

    public String getDescription() {
        return "Deforms an image stack according to distances provided in the given vector image stacks.\n\nIt is recommended to use 32-bit image stacks for input, output and vector image stacks.\n\nParameters\n----------\nsource : Image\n    The input image to be processed.\nvector_x : Image\n    Pixels in this image describe the distance in X direction pixels should be shifted during warping.\nvector_y : Image\n    Pixels in this image describe the distance in Y direction pixels should be shifted during warping.\nvector_z : Image\n    Pixels in this image describe the distance in Z direction pixels should be shifted during warping.\ndestination : Image\n    The output image where results are written into.\n";
    }

    public String getAvailableForDimensions() {
        return "3D";
    }

    public String getCategories() {
        return "Transform";
    }
}

