/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import ij.IJ;
import ij.process.AutoThresholder;

public class AutoThresholderImageJ1 {
    private static String[] mStrings;

    public static String[] getMethods() {
        if (mStrings == null) {
            AutoThresholder.Method[] mVals = AutoThresholder.Method.values();
            mStrings = new String[mVals.length];
            for (int i = 0; i < mVals.length; ++i) {
                AutoThresholderImageJ1.mStrings[i] = mVals[i].name();
            }
        }
        return mStrings;
    }

    public int getThreshold(AutoThresholder.Method method, int[] histogram) {
        if (histogram == null) {
            throw new IllegalArgumentException("Histogram is null");
        }
        if (histogram.length != 256) {
            throw new IllegalArgumentException("Histogram length not 256");
        }
        int threshold = 0;
        switch (method) {
            case Default: {
                threshold = this.defaultIsoData(histogram);
                break;
            }
            case IJ_IsoData: {
                threshold = this.IJIsoData(histogram);
                break;
            }
            case Huang: {
                threshold = this.Huang(histogram);
                break;
            }
            case Intermodes: {
                threshold = this.Intermodes(histogram);
                break;
            }
            case IsoData: {
                threshold = this.IsoData(histogram);
                break;
            }
            case Li: {
                threshold = this.Li(histogram);
                break;
            }
            case MaxEntropy: {
                threshold = this.MaxEntropy(histogram);
                break;
            }
            case Mean: {
                threshold = this.Mean(histogram);
                break;
            }
            case MinError: {
                threshold = this.MinErrorI(histogram);
                break;
            }
            case Minimum: {
                threshold = this.Minimum(histogram);
                break;
            }
            case Moments: {
                threshold = this.Moments(histogram);
                break;
            }
            case Otsu: {
                threshold = this.Otsu(histogram);
                break;
            }
            case Percentile: {
                threshold = this.Percentile(histogram);
                break;
            }
            case RenyiEntropy: {
                threshold = this.RenyiEntropy(histogram);
                break;
            }
            case Shanbhag: {
                threshold = this.Shanbhag(histogram);
                break;
            }
            case Triangle: {
                threshold = this.Triangle(histogram);
                break;
            }
            case Yen: {
                threshold = this.Yen(histogram);
            }
        }
        if (threshold == -1) {
            threshold = 0;
        }
        return threshold;
    }

    public int getThreshold(String mString, int[] histogram) {
        int index = mString.indexOf(" ");
        if (index != -1) {
            mString = mString.substring(0, index);
        }
        AutoThresholder.Method method = (AutoThresholder.Method)AutoThresholder.Method.valueOf(AutoThresholder.Method.class, (String)mString);
        return this.getThreshold(method, histogram);
    }

    int Huang(int[] data) {
        int ih;
        int threshold = -1;
        int first_bin = 0;
        for (ih = 0; ih < 256; ++ih) {
            if (data[ih] == 0) continue;
            first_bin = ih;
            break;
        }
        int last_bin = 255;
        for (ih = 255; ih >= first_bin; --ih) {
            if (data[ih] == 0) continue;
            last_bin = ih;
            break;
        }
        double term = 1.0 / (double)(last_bin - first_bin);
        double[] mu_0 = new double[256];
        double num_pix = 0.0;
        double sum_pix = 0.0;
        for (ih = first_bin; ih < 256; ++ih) {
            mu_0[ih] = (sum_pix += (double)ih * (double)data[ih]) / (num_pix += (double)data[ih]);
        }
        double[] mu_1 = new double[256];
        num_pix = 0.0;
        sum_pix = 0.0;
        for (ih = last_bin; ih > 0; --ih) {
            mu_1[ih - 1] = (sum_pix += (double)ih * (double)data[ih]) / (num_pix += (double)data[ih]);
        }
        threshold = -1;
        double min_ent = Double.MAX_VALUE;
        for (int it = 0; it < 256; ++it) {
            double mu_x;
            double ent = 0.0;
            for (ih = 0; ih <= it; ++ih) {
                mu_x = 1.0 / (1.0 + term * Math.abs((double)ih - mu_0[it]));
                if (mu_x < 1.0E-6 || mu_x > 0.999999) continue;
                ent += (double)data[ih] * (-mu_x * Math.log(mu_x) - (1.0 - mu_x) * Math.log(1.0 - mu_x));
            }
            for (ih = it + 1; ih < 256; ++ih) {
                mu_x = 1.0 / (1.0 + term * Math.abs((double)ih - mu_1[it]));
                if (mu_x < 1.0E-6 || mu_x > 0.999999) continue;
                ent += (double)data[ih] * (-mu_x * Math.log(mu_x) - (1.0 - mu_x) * Math.log(1.0 - mu_x));
            }
            if (!(ent < min_ent)) continue;
            min_ent = ent;
            threshold = it;
        }
        return threshold;
    }

    boolean bimodalTest(double[] y) {
        int len = y.length;
        boolean b = false;
        int modes = 0;
        for (int k = 1; k < len - 1; ++k) {
            if (!(y[k - 1] < y[k]) || !(y[k + 1] < y[k]) || ++modes <= 2) continue;
            return false;
        }
        if (modes == 2) {
            b = true;
        }
        return b;
    }

    int Intermodes(int[] data) {
        int i;
        int minbin = -1;
        int maxbin = -1;
        for (i = 0; i < data.length; ++i) {
            if (data[i] <= 0) continue;
            maxbin = i;
        }
        for (i = data.length - 1; i >= 0; --i) {
            if (data[i] <= 0) continue;
            minbin = i;
        }
        int length = maxbin - minbin + 1;
        double[] hist = new double[length];
        for (int i2 = minbin; i2 <= maxbin; ++i2) {
            hist[i2 - minbin] = data[i2];
        }
        int iter = 0;
        int threshold = -1;
        while (!this.bimodalTest(hist)) {
            double previous = 0.0;
            double current = 0.0;
            double next = hist[0];
            for (int i3 = 0; i3 < length - 1; ++i3) {
                previous = current;
                current = next;
                next = hist[i3 + 1];
                hist[i3] = (previous + current + next) / 3.0;
            }
            hist[length - 1] = (current + next) / 3.0;
            if (++iter <= 10000) continue;
            threshold = -1;
            IJ.log((String)"Intermodes Threshold not found after 10000 iterations.");
            return threshold;
        }
        int tt = 0;
        for (int i4 = 1; i4 < length - 1; ++i4) {
            if (!(hist[i4 - 1] < hist[i4]) || !(hist[i4 + 1] < hist[i4])) continue;
            tt += i4;
        }
        threshold = (int)Math.floor((double)tt / 2.0);
        return threshold + minbin;
    }

    int IsoData(int[] data) {
        int g;
        block4: {
            int i;
            g = 0;
            for (i = 1; i < 256; ++i) {
                if (data[i] <= 0) continue;
                g = i + 1;
                break;
            }
            do {
                int l = 0;
                int totl = 0;
                for (i = 0; i < g; ++i) {
                    totl += data[i];
                    l += data[i] * i;
                }
                double h = 0.0;
                double toth = 0.0;
                for (i = g + 1; i < 256; ++i) {
                    toth += (double)data[i];
                    h += (double)data[i] * (double)i;
                }
                if (totl > 0 && toth > 0.0 && g == (int)Math.round(((double)(l /= totl) + (h /= toth)) / 2.0)) break block4;
            } while (++g <= 254);
            return -1;
        }
        return g;
    }

    int defaultIsoData(int[] data) {
        int n = data.length;
        int[] data2 = new int[n];
        int mode = 0;
        int maxCount = 0;
        for (int i = 0; i < n; ++i) {
            int count = data[i];
            data2[i] = data[i];
            if (data2[i] <= maxCount) continue;
            maxCount = data2[i];
            mode = i;
        }
        int maxCount2 = 0;
        for (int i = 0; i < n; ++i) {
            if (data2[i] <= maxCount2 || i == mode) continue;
            maxCount2 = data2[i];
        }
        int hmax = maxCount;
        if (hmax > maxCount2 * 2 && maxCount2 != 0) {
            data2[mode] = hmax = (int)((double)maxCount2 * 1.5);
        }
        return this.IJIsoData(data2);
    }

    int IJIsoData(int[] data) {
        double sum4;
        double sum3;
        double sum2;
        double sum1;
        double result;
        int max;
        int min;
        int maxValue = data.length - 1;
        int count0 = data[0];
        data[0] = 0;
        int countMax = data[maxValue];
        data[maxValue] = 0;
        for (min = 0; data[min] == 0 && min < maxValue; ++min) {
        }
        for (max = maxValue; data[max] == 0 && max > 0; --max) {
        }
        if (min >= max) {
            data[0] = count0;
            data[maxValue] = countMax;
            int level = data.length / 2;
            return level;
        }
        int movingIndex = min;
        int inc = Math.max(max / 40, 1);
        do {
            int i;
            sum4 = 0.0;
            sum3 = 0.0;
            sum2 = 0.0;
            sum1 = 0.0;
            for (i = min; i <= movingIndex; ++i) {
                sum1 += (double)i * (double)data[i];
                sum2 += (double)data[i];
            }
            for (i = movingIndex + 1; i <= max; ++i) {
                sum3 += (double)i * (double)data[i];
                sum4 += (double)data[i];
            }
        } while ((double)(++movingIndex + 1) <= (result = (sum1 / sum2 + sum3 / sum4) / 2.0) && movingIndex < max - 1);
        data[0] = count0;
        data[maxValue] = countMax;
        int level = (int)Math.round(result);
        return level;
    }

    int Li(int[] data) {
        int threshold;
        double old_thresh;
        double sum_obj;
        double num_obj;
        double mean_obj;
        double mean_back;
        double temp;
        int ih;
        double tolerance = 0.5;
        double num_pixels = 0.0;
        for (ih = 0; ih < 256; ++ih) {
            num_pixels += (double)data[ih];
        }
        double mean = 0.0;
        for (ih = 1; ih < 256; ++ih) {
            mean += (double)ih * (double)data[ih];
        }
        double new_thresh = mean /= num_pixels;
        do {
            old_thresh = new_thresh;
            threshold = (int)(old_thresh + 0.5);
            double sum_back = 0.0;
            double num_back = 0.0;
            for (ih = 0; ih <= threshold; ++ih) {
                sum_back += (double)ih * (double)data[ih];
                num_back += (double)data[ih];
            }
            mean_back = num_back == 0.0 ? 0.0 : sum_back / num_back;
            sum_obj = 0.0;
            num_obj = 0.0;
            for (ih = threshold + 1; ih < 256; ++ih) {
                sum_obj += (double)ih * (double)data[ih];
                num_obj += (double)data[ih];
            }
        } while (Math.abs((new_thresh = (temp = (mean_back - (mean_obj = num_obj == 0.0 ? 0.0 : sum_obj / num_obj)) / (Math.log(mean_back) - Math.log(mean_obj))) < -2.220446049250313E-16 ? (double)((int)(temp - 0.5)) : (double)((int)(temp + 0.5))) - old_thresh) > tolerance);
        return threshold;
    }

    int MaxEntropy(int[] data) {
        int ih;
        int threshold = -1;
        double[] norm_histo = new double[256];
        double[] P1 = new double[256];
        double[] P2 = new double[256];
        double total = 0.0;
        for (ih = 0; ih < 256; ++ih) {
            total += (double)data[ih];
        }
        for (ih = 0; ih < 256; ++ih) {
            norm_histo[ih] = (double)data[ih] / total;
        }
        P1[0] = norm_histo[0];
        P2[0] = 1.0 - P1[0];
        for (ih = 1; ih < 256; ++ih) {
            P1[ih] = P1[ih - 1] + norm_histo[ih];
            P2[ih] = 1.0 - P1[ih];
        }
        int first_bin = 0;
        for (ih = 0; ih < 256; ++ih) {
            if (Math.abs(P1[ih]) < 2.220446049250313E-16) continue;
            first_bin = ih;
            break;
        }
        int last_bin = 255;
        for (ih = 255; ih >= first_bin; --ih) {
            if (Math.abs(P2[ih]) < 2.220446049250313E-16) continue;
            last_bin = ih;
            break;
        }
        double max_ent = Double.MIN_VALUE;
        for (int it = first_bin; it <= last_bin; ++it) {
            double ent_back = 0.0;
            for (ih = 0; ih <= it; ++ih) {
                if (data[ih] == 0) continue;
                ent_back -= norm_histo[ih] / P1[it] * Math.log(norm_histo[ih] / P1[it]);
            }
            double ent_obj = 0.0;
            for (ih = it + 1; ih < 256; ++ih) {
                if (data[ih] == 0) continue;
                ent_obj -= norm_histo[ih] / P2[it] * Math.log(norm_histo[ih] / P2[it]);
            }
            double tot_ent = ent_back + ent_obj;
            if (!(max_ent < tot_ent)) continue;
            max_ent = tot_ent;
            threshold = it;
        }
        return threshold;
    }

    int Mean(int[] data) {
        int threshold = -1;
        double tot = 0.0;
        double sum = 0.0;
        for (int i = 0; i < 256; ++i) {
            tot += (double)data[i];
            sum += (double)i * (double)data[i];
        }
        threshold = (int)Math.floor(sum / tot);
        return threshold;
    }

    int MinErrorI(int[] data) {
        int threshold = this.Mean(data);
        int Tprev = -2;
        while (threshold != Tprev) {
            double w2;
            double w0;
            double tau2;
            double mu = this.B(data, threshold) / this.A(data, threshold);
            double nu = (this.B(data, data.length - 1) - this.B(data, threshold)) / (this.A(data, data.length - 1) - this.A(data, threshold));
            double p = this.A(data, threshold) / this.A(data, data.length - 1);
            double q = (this.A(data, data.length - 1) - this.A(data, threshold)) / this.A(data, data.length - 1);
            double sigma2 = this.C(data, threshold) / this.A(data, threshold) - mu * mu;
            double w1 = mu / sigma2 - nu / (tau2 = (this.C(data, data.length - 1) - this.C(data, threshold)) / (this.A(data, data.length - 1) - this.A(data, threshold)) - nu * nu);
            double sqterm = w1 * w1 - (w0 = 1.0 / sigma2 - 1.0 / tau2) * (w2 = mu * mu / sigma2 - nu * nu / tau2 + Math.log10(sigma2 * (q * q) / (tau2 * (p * p))));
            if (sqterm < 0.0) {
                IJ.log((String)"MinError(I): not converging.");
                return threshold;
            }
            Tprev = threshold;
            double temp = (w1 + Math.sqrt(sqterm)) / w0;
            if (Double.isNaN(temp)) {
                threshold = Tprev;
                continue;
            }
            threshold = (int)Math.floor(temp);
        }
        return threshold;
    }

    private double A(int[] y, int j) {
        if (j >= y.length) {
            j = y.length - 1;
        }
        double x = 0.0;
        for (int i = 0; i <= j; ++i) {
            x += (double)y[i];
        }
        return x;
    }

    private double B(int[] y, int j) {
        if (j >= y.length) {
            j = y.length - 1;
        }
        double x = 0.0;
        for (int i = 0; i <= j; ++i) {
            x += (double)(i * y[i]);
        }
        return x;
    }

    private double C(int[] y, int j) {
        if (j >= y.length) {
            j = y.length - 1;
        }
        double x = 0.0;
        for (int i = 0; i <= j; ++i) {
            x += (double)(i * i * y[i]);
        }
        return x;
    }

    int Minimum(int[] data) {
        int i;
        int iter = 0;
        int threshold = -1;
        double[] iHisto = new double[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            iHisto[i2] = data[i2];
        }
        double[] tHisto = new double[iHisto.length];
        while (!this.bimodalTest(iHisto)) {
            for (i = 1; i < 255; ++i) {
                tHisto[i] = (iHisto[i - 1] + iHisto[i] + iHisto[i + 1]) / 3.0;
            }
            tHisto[0] = (iHisto[0] + iHisto[1]) / 3.0;
            tHisto[255] = (iHisto[254] + iHisto[255]) / 3.0;
            System.arraycopy(tHisto, 0, iHisto, 0, iHisto.length);
            if (++iter <= 10000) continue;
            threshold = -1;
            IJ.log((String)"Minimum: threshold not found after 10000 iterations.");
            return threshold;
        }
        for (i = 1; i < 255; ++i) {
            if (!(iHisto[i - 1] > iHisto[i]) || !(iHisto[i + 1] >= iHisto[i])) continue;
            threshold = i;
            break;
        }
        return threshold;
    }

    int Moments(int[] data) {
        int i;
        double total = 0.0;
        double m0 = 1.0;
        double m1 = 0.0;
        double m2 = 0.0;
        double m3 = 0.0;
        double sum = 0.0;
        double p0 = 0.0;
        int threshold = -1;
        double[] histo = new double[256];
        for (i = 0; i < 256; ++i) {
            total += (double)data[i];
        }
        for (i = 0; i < 256; ++i) {
            histo[i] = (double)data[i] / total;
        }
        for (i = 0; i < 256; ++i) {
            double di = i;
            m1 += di * histo[i];
            m2 += di * di * histo[i];
            m3 += di * di * di * histo[i];
        }
        double cd = m0 * m2 - m1 * m1;
        double c0 = (-m2 * m2 + m1 * m3) / cd;
        double c1 = (m0 * -m3 + m2 * m1) / cd;
        double z0 = 0.5 * (-c1 - Math.sqrt(c1 * c1 - 4.0 * c0));
        double z1 = 0.5 * (-c1 + Math.sqrt(c1 * c1 - 4.0 * c0));
        p0 = (z1 - m1) / (z1 - z0);
        sum = 0.0;
        for (i = 0; i < 256; ++i) {
            if (!((sum += histo[i]) > p0)) continue;
            threshold = i;
            break;
        }
        return threshold;
    }

    int Otsu(int[] data) {
        double L = 256.0;
        double N = 0.0;
        double S = 0.0;
        int k = 0;
        while ((double)k < L) {
            S += (double)k * (double)data[k];
            N += (double)data[k];
            ++k;
        }
        double Sk = 0.0;
        double N1 = data[0];
        double BCV = 0.0;
        double BCVmax = 0.0;
        int kStar = 0;
        k = 1;
        while ((double)k < L - 1.0) {
            double denom;
            Sk += (double)k * (double)data[k];
            if ((denom = (N1 += (double)data[k]) * (N - N1)) != 0.0) {
                double num = N1 / N * S - Sk;
                BCV = num * num / denom;
            } else {
                BCV = 0.0;
            }
            if (BCV >= BCVmax) {
                BCVmax = BCV;
                kStar = k;
            }
            ++k;
        }
        return kStar;
    }

    int Percentile(int[] data) {
        boolean iter = false;
        int threshold = -1;
        double ptile = 0.5;
        double[] avec = new double[256];
        for (int i = 0; i < 256; ++i) {
            avec[i] = 0.0;
        }
        double total = this.partialSum(data, 255);
        double temp = 1.0;
        for (int i = 0; i < 256; ++i) {
            avec[i] = Math.abs(this.partialSum(data, i) / total - ptile);
            if (!(avec[i] < temp)) continue;
            temp = avec[i];
            threshold = i;
        }
        return threshold;
    }

    double partialSum(int[] y, int j) {
        double x = 0.0;
        for (int i = 0; i <= j; ++i) {
            x += (double)y[i];
        }
        return x;
    }

    int RenyiEntropy(int[] data) {
        int beta3;
        int beta2;
        int beta1;
        int tmp_var;
        double tot_ent;
        double ent_obj;
        double ent_back;
        int it;
        int ih;
        double[] norm_histo = new double[256];
        double[] P1 = new double[256];
        double[] P2 = new double[256];
        double total = 0.0;
        for (ih = 0; ih < 256; ++ih) {
            total += (double)data[ih];
        }
        for (ih = 0; ih < 256; ++ih) {
            norm_histo[ih] = (double)data[ih] / total;
        }
        P1[0] = norm_histo[0];
        P2[0] = 1.0 - P1[0];
        for (ih = 1; ih < 256; ++ih) {
            P1[ih] = P1[ih - 1] + norm_histo[ih];
            P2[ih] = 1.0 - P1[ih];
        }
        int first_bin = 0;
        for (ih = 0; ih < 256; ++ih) {
            if (Math.abs(P1[ih]) < 2.220446049250313E-16) continue;
            first_bin = ih;
            break;
        }
        int last_bin = 255;
        for (ih = 255; ih >= first_bin; --ih) {
            if (Math.abs(P2[ih]) < 2.220446049250313E-16) continue;
            last_bin = ih;
            break;
        }
        int threshold = 0;
        double max_ent = 0.0;
        for (it = first_bin; it <= last_bin; ++it) {
            ent_back = 0.0;
            for (ih = 0; ih <= it; ++ih) {
                if (data[ih] == 0) continue;
                ent_back -= norm_histo[ih] / P1[it] * Math.log(norm_histo[ih] / P1[it]);
            }
            ent_obj = 0.0;
            for (ih = it + 1; ih < 256; ++ih) {
                if (data[ih] == 0) continue;
                ent_obj -= norm_histo[ih] / P2[it] * Math.log(norm_histo[ih] / P2[it]);
            }
            tot_ent = ent_back + ent_obj;
            if (!(max_ent < tot_ent)) continue;
            max_ent = tot_ent;
            threshold = it;
        }
        int t_star2 = threshold;
        threshold = 0;
        max_ent = 0.0;
        double alpha = 0.5;
        double term = 1.0 / (1.0 - alpha);
        for (it = first_bin; it <= last_bin; ++it) {
            ent_back = 0.0;
            for (ih = 0; ih <= it; ++ih) {
                ent_back += Math.sqrt(norm_histo[ih] / P1[it]);
            }
            ent_obj = 0.0;
            for (ih = it + 1; ih < 256; ++ih) {
                ent_obj += Math.sqrt(norm_histo[ih] / P2[it]);
            }
            tot_ent = term * (ent_back * ent_obj > 0.0 ? Math.log(ent_back * ent_obj) : 0.0);
            if (!(tot_ent > max_ent)) continue;
            max_ent = tot_ent;
            threshold = it;
        }
        int t_star1 = threshold;
        threshold = 0;
        max_ent = 0.0;
        alpha = 2.0;
        term = 1.0 / (1.0 - alpha);
        for (it = first_bin; it <= last_bin; ++it) {
            ent_back = 0.0;
            for (ih = 0; ih <= it; ++ih) {
                ent_back += norm_histo[ih] * norm_histo[ih] / (P1[it] * P1[it]);
            }
            ent_obj = 0.0;
            for (ih = it + 1; ih < 256; ++ih) {
                ent_obj += norm_histo[ih] * norm_histo[ih] / (P2[it] * P2[it]);
            }
            tot_ent = term * (ent_back * ent_obj > 0.0 ? Math.log(ent_back * ent_obj) : 0.0);
            if (!(tot_ent > max_ent)) continue;
            max_ent = tot_ent;
            threshold = it;
        }
        int t_star3 = threshold;
        if (t_star2 < t_star1) {
            tmp_var = t_star1;
            t_star1 = t_star2;
            t_star2 = tmp_var;
        }
        if (t_star3 < t_star2) {
            tmp_var = t_star2;
            t_star2 = t_star3;
            t_star3 = tmp_var;
        }
        if (t_star2 < t_star1) {
            tmp_var = t_star1;
            t_star1 = t_star2;
            t_star2 = tmp_var;
        }
        if (Math.abs(t_star1 - t_star2) <= 5) {
            if (Math.abs(t_star2 - t_star3) <= 5) {
                beta1 = 1;
                beta2 = 2;
                beta3 = 1;
            } else {
                beta1 = 0;
                beta2 = 1;
                beta3 = 3;
            }
        } else if (Math.abs(t_star2 - t_star3) <= 5) {
            beta1 = 3;
            beta2 = 1;
            beta3 = 0;
        } else {
            beta1 = 1;
            beta2 = 2;
            beta3 = 1;
        }
        double omega = P1[t_star3] - P1[t_star1];
        int opt_threshold = (int)((double)t_star1 * (P1[t_star1] + 0.25 * omega * (double)beta1) + 0.25 * (double)t_star2 * omega * (double)beta2 + (double)t_star3 * (P2[t_star3] + 0.25 * omega * (double)beta3));
        return opt_threshold;
    }

    int Shanbhag(int[] data) {
        int ih;
        double[] norm_histo = new double[256];
        double[] P1 = new double[256];
        double[] P2 = new double[256];
        double total = 0.0;
        for (ih = 0; ih < 256; ++ih) {
            total += (double)data[ih];
        }
        for (ih = 0; ih < 256; ++ih) {
            norm_histo[ih] = (double)data[ih] / total;
        }
        P1[0] = norm_histo[0];
        P2[0] = 1.0 - P1[0];
        for (ih = 1; ih < 256; ++ih) {
            P1[ih] = P1[ih - 1] + norm_histo[ih];
            P2[ih] = 1.0 - P1[ih];
        }
        int first_bin = 0;
        for (ih = 0; ih < 256; ++ih) {
            if (Math.abs(P1[ih]) < 2.220446049250313E-16) continue;
            first_bin = ih;
            break;
        }
        int last_bin = 255;
        for (ih = 255; ih >= first_bin; --ih) {
            if (Math.abs(P2[ih]) < 2.220446049250313E-16) continue;
            last_bin = ih;
            break;
        }
        int threshold = -1;
        double min_ent = Double.MAX_VALUE;
        for (int it = first_bin; it <= last_bin; ++it) {
            double ent_back = 0.0;
            double term = 0.5 / P1[it];
            for (ih = 1; ih <= it; ++ih) {
                ent_back -= norm_histo[ih] * Math.log(1.0 - term * P1[ih - 1]);
            }
            ent_back *= term;
            double ent_obj = 0.0;
            term = 0.5 / P2[it];
            for (ih = it + 1; ih < 256; ++ih) {
                ent_obj -= norm_histo[ih] * Math.log(1.0 - term * P2[ih]);
            }
            double tot_ent = Math.abs(ent_back - (ent_obj *= term));
            if (!(tot_ent < min_ent)) continue;
            min_ent = tot_ent;
            threshold = it;
        }
        return threshold;
    }

    int Triangle(int[] data) {
        int i;
        int min = 0;
        int dmax = 0;
        int max = 0;
        int min2 = 0;
        for (i = 0; i < data.length; ++i) {
            if (data[i] <= 0) continue;
            min = i;
            break;
        }
        if (min > 0) {
            --min;
        }
        for (i = 255; i > 0; --i) {
            if (data[i] <= 0) continue;
            min2 = i;
            break;
        }
        if (min2 < 255) {
            ++min2;
        }
        for (i = 0; i < 256; ++i) {
            if (data[i] <= dmax) continue;
            max = i;
            dmax = data[i];
        }
        boolean inverted = false;
        if (max - min < min2 - max) {
            inverted = true;
            int left = 0;
            for (int right = 255; left < right; ++left, --right) {
                int temp = data[left];
                data[left] = data[right];
                data[right] = temp;
            }
            min = 255 - min2;
            max = 255 - max;
        }
        if (min == max) {
            return min;
        }
        double nx = data[max];
        double ny = min - max;
        double d = Math.sqrt(nx * nx + ny * ny);
        nx /= d;
        ny /= d;
        d = nx * (double)min + ny * (double)data[min];
        int split = min;
        double splitDistance = 0.0;
        for (int i2 = min + 1; i2 <= max; ++i2) {
            double newDistance = nx * (double)i2 + ny * (double)data[i2] - d;
            if (!(newDistance > splitDistance)) continue;
            split = i2;
            splitDistance = newDistance;
        }
        --split;
        if (inverted) {
            int left = 0;
            for (int right = 255; left < right; ++left, --right) {
                int temp = data[left];
                data[left] = data[right];
                data[right] = temp;
            }
            return 255 - split;
        }
        return split;
    }

    int Yen(int[] data) {
        int ih;
        double[] norm_histo = new double[256];
        double[] P1 = new double[256];
        double[] P1_sq = new double[256];
        double[] P2_sq = new double[256];
        double total = 0.0;
        for (ih = 0; ih < 256; ++ih) {
            total += (double)data[ih];
        }
        for (ih = 0; ih < 256; ++ih) {
            norm_histo[ih] = (double)data[ih] / total;
        }
        P1[0] = norm_histo[0];
        for (ih = 1; ih < 256; ++ih) {
            P1[ih] = P1[ih - 1] + norm_histo[ih];
        }
        P1_sq[0] = norm_histo[0] * norm_histo[0];
        for (ih = 1; ih < 256; ++ih) {
            P1_sq[ih] = P1_sq[ih - 1] + norm_histo[ih] * norm_histo[ih];
        }
        P2_sq[255] = 0.0;
        for (ih = 254; ih >= 0; --ih) {
            P2_sq[ih] = P2_sq[ih + 1] + norm_histo[ih + 1] * norm_histo[ih + 1];
        }
        int threshold = -1;
        double max_crit = Double.MIN_VALUE;
        for (int it = 0; it < 256; ++it) {
            double crit = -1.0 * (P1_sq[it] * P2_sq[it] > 0.0 ? Math.log(P1_sq[it] * P2_sq[it]) : 0.0) + 2.0 * (P1[it] * (1.0 - P1[it]) > 0.0 ? Math.log(P1[it] * (1.0 - P1[it])) : 0.0);
            if (!(crit > max_crit)) continue;
            max_crit = crit;
            threshold = it;
        }
        return threshold;
    }

    public static enum Method {
        Default,
        Huang,
        Intermodes,
        IsoData,
        IJ_IsoData,
        Li,
        MaxEntropy,
        Mean,
        MinError,
        Minimum,
        Moments,
        Otsu,
        Percentile,
        RenyiEntropy,
        Shanbhag,
        Triangle,
        Yen;

    }
}

