/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.Arrays;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.plugins.AutoThresholderImageJ1;
import net.haesleinhuepf.clij2.plugins.GetAutomaticThreshold;
import net.haesleinhuepf.clij2.utilities.HasAuthor;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.HasLicense;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_automaticThreshold")
public class AutomaticThreshold
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
HasAuthor,
HasLicense,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Binary Image";
    }

    public boolean executeCL() {
        ClearCLBuffer src = (ClearCLBuffer)this.args[0];
        ClearCLBuffer dst = (ClearCLBuffer)this.args[1];
        String userSelectedMethod = (String)this.args[2];
        return this.getCLIJ2().automaticThreshold(src, dst, userSelectedMethod);
    }

    public static boolean automaticThreshold(CLIJ2 clij2, ClearCLBuffer src, ClearCLBuffer dst, String userSelectedMethod) {
        CLIJUtilities.assertDifferent((Object)src, (Object)dst);
        Float minimumGreyValue = Float.valueOf(0.0f);
        Float maximumGreyValue = Float.valueOf(0.0f);
        Integer numberOfBins = 256;
        if (src.getNativeType() == NativeTypeEnum.UnsignedByte) {
            minimumGreyValue = Float.valueOf(0.0f);
            maximumGreyValue = Float.valueOf(255.0f);
        } else {
            minimumGreyValue = null;
            maximumGreyValue = null;
        }
        return AutomaticThreshold.automaticThreshold(clij2, src, dst, userSelectedMethod, minimumGreyValue, maximumGreyValue, numberOfBins);
    }

    public static boolean automaticThreshold(CLIJ2 clij2, ClearCLBuffer src, ClearCLBuffer dst, String userSelectedMethod, Float minimumGreyValue, Float maximumGreyValue, Integer numberOfBins) {
        double threshold = GetAutomaticThreshold.getAutomaticThreshold(clij2, src, userSelectedMethod, minimumGreyValue, maximumGreyValue, numberOfBins);
        clij2.threshold((ClearCLImageInterface)src, (ClearCLImageInterface)dst, threshold);
        return true;
    }

    public String getDescription() {
        StringBuilder doc = new StringBuilder();
        doc.append("The automatic thresholder utilizes the threshold methods from ImageJ on a histogram determined on \nthe GPU to create binary images as similar as possible to ImageJ 'Apply Threshold' method.\n\n Enter one \nof these methods in the method text field:\n" + Arrays.toString(AutoThresholderImageJ1.getMethods()));
        return doc.toString();
    }

    public String getParameterHelpText() {
        return "Image input, ByRef Image destination, String method";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public String getAuthorName() {
        return "Robert Haase based on work by G. Landini and W. Rasband";
    }

    public String getLicense() {
        return "The code for the automatic thresholding methods originates from https://github.com/imagej/imagej1/blob/master/ij/process/AutoThresholder.java\n\nDetailed documentation on the implemented methods can be found online: https://imagej.net/Auto_Threshold";
    }

    public String getCategories() {
        return "Binary, Segmentation";
    }
}

