/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_averageDistanceOfNFarOffPoints")
public class AverageDistanceOfNFarOffPoints
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Matrix";
    }

    @Override
    public String getOutputType() {
        return "Vector";
    }

    public String getCategories() {
        return "Measurements, Graph";
    }

    public String getParameterHelpText() {
        return "Image distance_matrix, ByRef Image distance+_list_destination, Number n_far_off_points_to_find";
    }

    public boolean executeCL() {
        Object[] args = this.openCLBufferArgs();
        boolean result = AverageDistanceOfNFarOffPoints.averageDistanceOfNFarOffPoints(this.getCLIJ2(), (ClearCLBuffer)args[0], (ClearCLBuffer)args[1], AverageDistanceOfNFarOffPoints.asInteger((Object)args[2]));
        this.releaseBuffers(args);
        return result;
    }

    public static boolean averageDistanceOfNFarOffPoints(CLIJ2 clij2, ClearCLBuffer distance_matrix, ClearCLBuffer indexlist_destination, Integer nPoints) {
        if (indexlist_destination.getHeight() > 1000L) {
            System.out.println("Warning: NFarOffPoints is limited to n=1000 for technical reasons.");
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src_distancematrix", distance_matrix);
        parameters.put("dst_indexlist", indexlist_destination);
        parameters.put("nPoints", nPoints);
        long[] globalSizes = new long[]{distance_matrix.getWidth()};
        clij2.activateSizeIndependentKernelCompilation();
        clij2.execute(AverageDistanceOfNFarOffPoints.class, "average_distance_of_n_far_off_distances_x.cl", "average_distance_of_n_far_off_points", globalSizes, globalSizes, parameters);
        return true;
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        return this.clij.create(new long[]{input.getWidth(), 1L, 1L}, NativeTypeEnum.Float);
    }

    public String getDescription() {
        return "Determines the average of the n far off (most distant) points for every point in a distance matrix.\n\nThis corresponds to the average of the n maximum values (rows) for each column of the distance matrix.\n\nParameters\n----------\ndistance_matrix : Image\n    The a distance matrix to be processed.\ndistance_list_destination : Image\n    A vector image with the same width as the distance matrix and height=1, depth=1.\n    Determined average distances will be written into this vector.\nn_far_off_points_to_find : Number\n    Number of largest distances which should be averaged.\n";
    }

    public String getAvailableForDimensions() {
        return "2D";
    }
}

