/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_binaryAnd")
public class BinaryAnd
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Binary Image";
    }

    @Override
    public String getOutputType() {
        return "Binary Image";
    }

    public boolean executeCL() {
        return this.getCLIJ2().binaryAnd((ClearCLImageInterface)((ClearCLBuffer)this.args[0]), (ClearCLImageInterface)((ClearCLBuffer)this.args[1]), (ClearCLImageInterface)((ClearCLBuffer)this.args[2]));
    }

    public static boolean binaryAnd(CLIJ2 clij2, ClearCLImageInterface src1, ClearCLImageInterface src2, ClearCLImageInterface dst) {
        CLIJUtilities.assertDifferent((Object)src1, (Object)dst);
        CLIJUtilities.assertDifferent((Object)src2, (Object)dst);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src1", src1);
        parameters.put("src2", src2);
        parameters.put("dst", dst);
        clij2.execute(BinaryAnd.class, "binary_and_" + src1.getDimension() + "d_x.cl", "binary_and_" + src1.getDimension() + "d", dst.getDimensions(), dst.getDimensions(), parameters);
        return true;
    }

    public String getParameterHelpText() {
        return "Image operand1, Image operand2, ByRef Image destination";
    }

    public String getDescription() {
        return "Computes a binary image (containing pixel values 0 and 1) from two images X and Y by connecting pairs of\npixels x and y with the binary AND operator &.\nAll pixel values except 0 in the input images are interpreted as 1.\n\n<pre>f(x, y) = x & y</pre>\n\nParameters\n----------\noperand1 : Image\n    The first binary input image to be processed.\noperand2 : Image\n    The second binary input image to be processed.\ndestination : Image\n    The output image where results are written into.\n";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public String getCategories() {
        return "Binary, Math";
    }
}

