/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.plugins.FloodFillDiamond;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_binaryFillHoles")
public class BinaryFillHoles
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Binary Image";
    }

    @Override
    public String getOutputType() {
        return "Binary Image";
    }

    public boolean executeCL() {
        this.getCLIJ2().binaryFillHoles((ClearCLImageInterface)((ClearCLBuffer)this.args[0]), (ClearCLImageInterface)((ClearCLBuffer)this.args[1]));
        return true;
    }

    public static boolean binaryFillHoles(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst) {
        CLIJUtilities.assertDifferent((Object)src, (Object)dst);
        long[] dims = src.getDimension() == 3L ? new long[3] : new long[2];
        for (int d = 0; d < dims.length; ++d) {
            dims[d] = src.getDimensions()[d] + 2L;
        }
        ClearCLBuffer temp = clij2.create(dims, dst.getNativeType());
        ClearCLBuffer temp2 = clij2.create(dims, dst.getNativeType());
        if (src.getDimension() == 3L) {
            clij2.paste(src, (ClearCLImageInterface)temp, 1.0, 1.0, 1.0);
        } else {
            clij2.paste(src, (ClearCLImageInterface)temp, 1.0, 1.0);
        }
        clij2.setImageBorders((ClearCLImageInterface)temp, 2.0);
        FloodFillDiamond.floodFillDiamond(clij2, temp, temp2, Float.valueOf(0.0f), Float.valueOf(2.0f));
        clij2.notEqualConstant(temp2, temp, 2.0);
        if (src.getDimension() == 3L) {
            clij2.crop((ClearCLImageInterface)temp, dst, 1.0, 1.0, 1.0);
        } else {
            clij2.crop((ClearCLImageInterface)temp, dst, 1.0, 1.0);
        }
        clij2.release((ClearCLImageInterface)temp);
        clij2.release((ClearCLImageInterface)temp2);
        return true;
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination";
    }

    public String getDescription() {
        return "Fills holes (pixels with value 0 surrounded by pixels with value 1) in a binary image.\n\nNote: This function is known to perform slowly on large images. Consider using the extension \nCLIJx_morphoLibJFillHoles(input, destination) instead.\nRead more: http://clij.github.io/assistant/installation#extensions\n\nParameters\n----------\nsource : Image\n    The binary input image where holes will be filled.\ndestination : Image\n    The output image where true pixels will be 1.\n";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public String getCategories() {
        return "Binary, Filter";
    }
}

