/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_binaryNot")
public class BinaryNot
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Binary Image";
    }

    @Override
    public String getOutputType() {
        return "Binary Image";
    }

    public boolean executeCL() {
        this.getCLIJ2().binaryNot((ClearCLImageInterface)((ClearCLBuffer)this.args[0]), (ClearCLImageInterface)((ClearCLBuffer)this.args[1]));
        return true;
    }

    public static boolean binaryNot(CLIJ2 clij2, ClearCLImageInterface src1, ClearCLImageInterface dst) {
        CLIJUtilities.assertDifferent((Object)src1, (Object)dst);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src1", src1);
        parameters.put("dst", dst);
        clij2.execute(BinaryNot.class, "binary_not_" + src1.getDimension() + "d_x.cl", "binary_not_" + src1.getDimension() + "d", dst.getDimensions(), dst.getDimensions(), parameters);
        return true;
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination";
    }

    public String getDescription() {
        return "Computes a binary image (containing pixel values 0 and 1) from an image X by negating its pixel values\nx using the binary NOT operator !\n\nAll pixel values except 0 in the input image are interpreted as 1.\n\n<pre>f(x) = !x</pre>\n\nParameters\n----------\nsource : Image\n    The binary input image to be inverted.\ndestination : Image\n    The output image where results are written into.\n";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public String getCategories() {
        return "Binary, Filter, Math";
    }
}

