/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_bottomHatSphere")
public class BottomHatSphere
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getParameterHelpText() {
        return "Image input, ByRef Image destination, Number radiusX, Number radiusY, Number radiusZ";
    }

    public boolean executeCL() {
        Object[] args = this.openCLBufferArgs();
        boolean result = this.getCLIJ2().bottomHatSphere((ClearCLBuffer)args[0], (ClearCLBuffer)args[1], BottomHatSphere.asInteger((Object)args[2]).intValue(), BottomHatSphere.asInteger((Object)args[3]).intValue(), BottomHatSphere.asInteger((Object)args[4]).intValue());
        this.releaseBuffers(args);
        return result;
    }

    public static boolean bottomHatSphere(CLIJ2 clij2, ClearCLBuffer input, ClearCLBuffer output, Integer radiusX, Integer radiusY, Integer radiusZ) {
        ClearCLBuffer temp1 = clij2.create(input);
        ClearCLBuffer temp2 = clij2.create(input);
        if (input.getDimension() == 3L) {
            clij2.maximum3DSphere((ClearCLImageInterface)input, (ClearCLImageInterface)temp1, radiusX.intValue(), radiusX.intValue(), radiusZ.intValue());
            clij2.minimum3DSphere((ClearCLImageInterface)temp1, (ClearCLImageInterface)temp2, radiusX.intValue(), radiusY.intValue(), radiusZ.intValue());
        } else {
            clij2.maximum2DSphere((ClearCLImageInterface)input, (ClearCLImageInterface)temp1, radiusX.intValue(), radiusX.intValue());
            clij2.minimum2DSphere((ClearCLImageInterface)temp1, (ClearCLImageInterface)temp2, radiusX.intValue(), radiusY.intValue());
        }
        clij2.subtractImages((ClearCLImageInterface)temp2, (ClearCLImageInterface)input, (ClearCLImageInterface)output);
        temp1.close();
        temp2.close();
        return true;
    }

    public String getDescription() {
        return "Applies a bottom-hat filter for background subtraction to the input image.\n\nParameters\n----------\ninput : Image\n    The input image where the background is subtracted from.\ndestination : Image\n    The output image where results are written into.\nradius_x : Image\n    Radius of the background determination region in X.\nradius_y : Image\n    Radius of the background determination region in Y.\nradius_z : Image\n    Radius of the background determination region in Z.\n";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public String getCategories() {
        return "Background, Filter";
    }
}

