/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import ij.measure.ResultsTable;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_centerOfMass")
public class CenterOfMass
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized {
    public String getCategories() {
        return "Measurements";
    }

    public boolean executeCL() {
        ResultsTable table = ResultsTable.getResultsTable();
        table.incrementCounter();
        ClearCLBuffer input = (ClearCLBuffer)this.args[0];
        double[] center = this.getCLIJ2().centerOfMass(input);
        table.addValue("MassX", center[0]);
        table.addValue("MassY", center[1]);
        if (input.getDimension() > 2L && input.getDepth() > 1L) {
            table.addValue("MassZ", center[2]);
        }
        this.releaseBuffers(this.args);
        table.show("Results");
        return true;
    }

    public static double[] centerOfMass(CLIJ2 clij2, ClearCLBuffer input) {
        ClearCLBuffer multipliedWithCoordinate = clij2.create(input.getDimensions(), NativeTypeEnum.Float);
        double sum = clij2.sumOfAllPixels((ClearCLImageInterface)input);
        double[] resultCenterOfMass = input.getDimension() > 2L && input.getDepth() > 1L ? new double[3] : new double[2];
        clij2.multiplyImageAndCoordinate((ClearCLImageInterface)input, (ClearCLImageInterface)multipliedWithCoordinate, 0.0);
        double sumX = clij2.sumOfAllPixels((ClearCLImageInterface)multipliedWithCoordinate);
        resultCenterOfMass[0] = sumX / sum;
        clij2.multiplyImageAndCoordinate((ClearCLImageInterface)input, (ClearCLImageInterface)multipliedWithCoordinate, 1.0);
        double sumY = clij2.sumOfAllPixels((ClearCLImageInterface)multipliedWithCoordinate);
        resultCenterOfMass[1] = sumY / sum;
        if (input.getDimension() > 2L && input.getDepth() > 1L) {
            clij2.multiplyImageAndCoordinate((ClearCLImageInterface)input, (ClearCLImageInterface)multipliedWithCoordinate, 2.0);
            double sumZ = clij2.sumOfAllPixels((ClearCLImageInterface)multipliedWithCoordinate);
            resultCenterOfMass[2] = sumZ / sum;
        }
        multipliedWithCoordinate.close();
        return resultCenterOfMass;
    }

    public String getParameterHelpText() {
        return "Image source";
    }

    public String getDescription() {
        return "Determines the center of mass of an image or image stack. \n\nIt writes the result in the results table\nin the columns MassX, MassY and MassZ.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

