/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.plugins.ReplaceIntensities;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_closeIndexGapsInLabelMap")
public class CloseIndexGapsInLabelMap
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Label Image";
    }

    @Override
    public String getOutputType() {
        return "Label Image";
    }

    public boolean executeCL() {
        Object[] args = this.openCLBufferArgs();
        ClearCLBuffer input = (ClearCLBuffer)args[0];
        ClearCLBuffer output = (ClearCLBuffer)args[1];
        boolean result = this.getCLIJ2().closeIndexGapsInLabelMap(input, (ClearCLImageInterface)output);
        this.releaseBuffers(args);
        return result;
    }

    @Deprecated
    public static boolean shiftIntensitiesToCloseGaps(CLIJ2 clij2, ClearCLBuffer input, ClearCLBuffer output) {
        return CloseIndexGapsInLabelMap.closeIndexGapsInLabelMap(clij2, input, (ClearCLImageInterface)output);
    }

    public static boolean closeIndexGapsInLabelMap(CLIJ2 clij2, ClearCLBuffer input, ClearCLImageInterface output) {
        int maximum = (int)clij2.maximumOfAllPixels((ClearCLImageInterface)input);
        float[] allNewIndices = new float[maximum + 1];
        float[] count = new float[]{1.0f};
        long number_of_pixels = (int)(input.getWidth() * input.getHeight() * input.getDepth());
        if (number_of_pixels < Integer.MAX_VALUE && input.getNativeType() == NativeTypeEnum.Float) {
            float[] slice = new float[(int)number_of_pixels];
            FloatBuffer buffer = FloatBuffer.wrap(slice);
            input.writeTo((Buffer)buffer, true);
            for (int i = 0; i < slice.length; ++i) {
                int key = (int)slice[i];
                if (key <= 0 || allNewIndices[key] != 0.0f) continue;
                allNewIndices[key] = count[0];
                count[0] = count[0] + 1.0f;
            }
        } else {
            RandomAccessibleInterval rai = clij2.convert(input, RandomAccessibleInterval.class);
            Cursor cursor = Views.iterable((RandomAccessibleInterval)rai).cursor();
            while (cursor.hasNext()) {
                int key = new Float(((RealType)cursor.next()).getRealFloat()).intValue();
                if (key <= 0 || allNewIndices[key] != 0.0f) continue;
                allNewIndices[key] = count[0];
                count[0] = count[0] + 1.0f;
            }
        }
        ClearCLBuffer keyValueMap = clij2.create(new long[]{allNewIndices.length, 1L, 1L}, NativeTypeEnum.Float);
        keyValueMap.readFrom((Buffer)FloatBuffer.wrap(allNewIndices), true);
        ReplaceIntensities.replaceIntensities(clij2, (ClearCLImageInterface)input, (ClearCLImageInterface)keyValueMap, output);
        keyValueMap.close();
        return true;
    }

    public String getParameterHelpText() {
        return "Image labeling_input, ByRef Image labeling_destination";
    }

    public String getDescription() {
        return "Analyses a label map and if there are gaps in the indexing (e.g. label 5 is not present) all \nsubsequent labels will be relabelled. \n\nThus, afterwards number of labels and maximum label index are equal.\nThis operation is mostly performed on the CPU.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        return this.clij.create(input.getDimensions(), NativeTypeEnum.Float);
    }

    public String getCategories() {
        return "Label";
    }
}

