/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_closingBox")
public class ClosingBox
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Binary Image";
    }

    @Override
    public String getOutputType() {
        return "Binary Image";
    }

    public String getParameterHelpText() {
        return "Image input, ByRef Image destination, Number number_of_dilations_and_erosions";
    }

    public boolean executeCL() {
        Object[] args = this.openCLBufferArgs();
        boolean result = this.getCLIJ2().closingBox((ClearCLBuffer)args[0], (ClearCLBuffer)args[1], ClosingBox.asInteger((Object)args[2]).intValue());
        this.releaseBuffers(args);
        return result;
    }

    public static boolean closingBox(CLIJ2 clij2, ClearCLBuffer input, ClearCLBuffer output, Integer radius) {
        ClearCLBuffer swap;
        int i;
        ClearCLBuffer temp1 = clij2.create(input);
        ClearCLBuffer temp2 = clij2.create(input);
        clij2.dilateBox((ClearCLImageInterface)input, (ClearCLImageInterface)temp1);
        for (i = 1; i < radius; ++i) {
            clij2.dilateBox((ClearCLImageInterface)temp1, (ClearCLImageInterface)temp2);
            swap = temp1;
            temp1 = temp2;
            temp2 = swap;
        }
        for (i = 1; i < radius; ++i) {
            clij2.erodeBox((ClearCLImageInterface)temp1, (ClearCLImageInterface)temp2);
            swap = temp1;
            temp1 = temp2;
            temp2 = swap;
        }
        clij2.erodeBox((ClearCLImageInterface)temp1, (ClearCLImageInterface)output);
        clij2.release((ClearCLImageInterface)temp1);
        clij2.release((ClearCLImageInterface)temp2);
        return true;
    }

    public String getDescription() {
        return "Apply a binary closing to the input image by calling n dilations and n erosions subsequenntly.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public String getCategories() {
        return "Binary, Filter";
    }
}

