/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import ij.ImagePlus;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLKernel;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.plugins.CloseIndexGapsInLabelMap;
import net.haesleinhuepf.clij2.plugins.NonzeroMinimumBox;
import net.haesleinhuepf.clij2.plugins.NonzeroMinimumDiamond;
import net.haesleinhuepf.clij2.plugins.SetNonZeroPixelsToPixelIndex;
import org.scijava.plugin.Plugin;

@Deprecated
@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_connectedComponentsLabeling")
public class ConnectedComponentsLabeling
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation {
    public boolean executeCL() {
        Object[] args = this.openCLBufferArgs();
        ClearCLBuffer input = (ClearCLBuffer)args[0];
        ClearCLBuffer output = (ClearCLBuffer)args[1];
        boolean result = this.getCLIJ2().connectedComponentsLabeling((ClearCLImageInterface)input, (ClearCLImageInterface)output);
        this.releaseBuffers(args);
        return result;
    }

    @Deprecated
    public static boolean connectedComponentsLabeling(CLIJ2 clij2, ClearCLImageInterface input, ClearCLImageInterface output) {
        return ConnectedComponentsLabeling.connectedComponentsLabeling_internal(clij2, input, output, true, true);
    }

    protected static boolean connectedComponentsLabeling_internal(CLIJ2 clij2, ClearCLImageInterface input, ClearCLImageInterface output, boolean forceContinousLabeling, boolean useBoxNeighborhood) {
        ClearCLBuffer temp1 = clij2.create(output.getDimensions());
        ClearCLBuffer temp2 = clij2.create(output.getDimensions());
        ClearCLBuffer temp3 = clij2.create(output.getDimensions());
        ClearCLBuffer flag = clij2.create(new long[]{1L, 1L, 1L}, NativeTypeEnum.Byte);
        ByteBuffer aByteBufferWithAZero = ByteBuffer.allocate(1);
        aByteBufferWithAZero.put((byte)0);
        flag.readFrom((Buffer)aByteBufferWithAZero, true);
        SetNonZeroPixelsToPixelIndex.setNonZeroPixelsToPixelIndex(clij2, input, (ClearCLImageInterface)temp1);
        clij2.set((ClearCLImageInterface)temp2, 0.0);
        int[] iterationCount = new int[]{0};
        int flagValue = 1;
        ClearCLKernel flipkernel = null;
        ClearCLKernel flopkernel = null;
        while (flagValue > 0) {
            if (iterationCount[0] % 2 == 0) {
                if (flipkernel == null) {
                    flipkernel = useBoxNeighborhood ? NonzeroMinimumBox.nonzeroMinimumBox(clij2, (ClearCLImageInterface)temp1, (ClearCLImageInterface)flag, (ClearCLImageInterface)temp2, flipkernel) : NonzeroMinimumDiamond.nonzeroMinimumDiamond(clij2, (ClearCLImageInterface)temp1, (ClearCLImageInterface)flag, (ClearCLImageInterface)temp2, flipkernel);
                } else {
                    flipkernel.run(true);
                }
            } else if (flopkernel == null) {
                flopkernel = useBoxNeighborhood ? NonzeroMinimumBox.nonzeroMinimumBox(clij2, (ClearCLImageInterface)temp2, (ClearCLImageInterface)flag, (ClearCLImageInterface)temp1, flopkernel) : NonzeroMinimumDiamond.nonzeroMinimumDiamond(clij2, (ClearCLImageInterface)temp2, (ClearCLImageInterface)flag, (ClearCLImageInterface)temp1, flopkernel);
            } else {
                flopkernel.run(true);
            }
            ImagePlus flagImp = clij2.pull(flag);
            flagValue = flagImp.getProcessor().get(0, 0);
            flag.readFrom((Buffer)aByteBufferWithAZero, true);
            iterationCount[0] = iterationCount[0] + 1;
        }
        if (iterationCount[0] % 2 == 0) {
            clij2.copy((ClearCLImageInterface)temp1, (ClearCLImageInterface)temp3);
        } else {
            clij2.copy((ClearCLImageInterface)temp2, (ClearCLImageInterface)temp3);
        }
        if (flipkernel != null) {
            flipkernel.close();
        }
        if (flopkernel != null) {
            flopkernel.close();
        }
        if (forceContinousLabeling) {
            CloseIndexGapsInLabelMap.closeIndexGapsInLabelMap(clij2, temp3, output);
        } else {
            clij2.copy((ClearCLImageInterface)temp3, output);
        }
        clij2.release((ClearCLImageInterface)temp1);
        clij2.release((ClearCLImageInterface)temp2);
        clij2.release((ClearCLImageInterface)temp3);
        clij2.release((ClearCLImageInterface)flag);
        return true;
    }

    public String getParameterHelpText() {
        return "Image binary_input, ByRef Image labeling_destination";
    }

    public String getDescription() {
        return "Performs connected components analysis to a binary image and generates a label map.\n\nDEPRECATED: This method is deprecated. Use ConnectedComponentsLabellingBox (or Diamond) instead.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        return this.clij.create(input.getDimensions(), NativeTypeEnum.Float);
    }
}

