/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_copySlice")
public class CopySlice
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Transform";
    }

    public Object[] getDefaultValues() {
        return new Object[]{null, null, 0};
    }

    public boolean executeCL() {
        return this.getCLIJ2().copySlice((ClearCLImageInterface)((ClearCLBuffer)this.args[0]), (ClearCLImageInterface)((ClearCLBuffer)this.args[1]), CopySlice.asInteger((Object)this.args[2]).intValue());
    }

    public static boolean copySlice(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, Integer planeIndex) {
        CLIJUtilities.assertDifferent((Object)src, (Object)dst);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src", src);
        parameters.put("dst", dst);
        parameters.put("slice", planeIndex);
        clij2.activateSizeIndependentKernelCompilation();
        if (src.getDimension() == 2L && dst.getDimension() == 3L) {
            clij2.execute(CopySlice.class, "copy_slice_to_3d_x.cl", "copy_slice_to_3d", src.getDimensions(), src.getDimensions(), parameters);
        } else if (src.getDimension() == 3L && dst.getDimension() == 2L) {
            clij2.execute(CopySlice.class, "copy_slice_from_3d_x.cl", "copy_slice_from_3d", dst.getDimensions(), dst.getDimensions(), parameters);
        } else {
            clij2.copy(src, dst);
        }
        return true;
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination, Number slice_index";
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        if (input.getDimension() == 2L) {
            return this.clij.createCLBuffer(new long[]{input.getWidth(), input.getHeight(), CopySlice.asInteger((Object)this.args[2]) + 1}, input.getNativeType());
        }
        return this.clij.createCLBuffer(new long[]{input.getWidth(), input.getHeight()}, input.getNativeType());
    }

    public String getDescription() {
        return "This method has two purposes: \nIt copies a 2D image to a given slice z position in a 3D image stack or \nIt copies a given slice at position z in an image stack to a 2D image.\n\nThe first case is only available via ImageJ macro. If you are using it, it is recommended that the \ntarget 3D image already pre-exists in GPU memory before calling this method. Otherwise, CLIJ create \nthe image stack with z planes.";
    }

    public String getAvailableForDimensions() {
        return "3D -> 2D and 2D -> 3D";
    }
}

