/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_countNonZeroPixels2DSphere")
public class CountNonZeroPixels2DSphere
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Measurements, Filter";
    }

    public boolean executeCL() {
        return this.getCLIJ2().countNonZeroPixelsLocally((ClearCLBuffer)this.args[0], (ClearCLBuffer)this.args[1], CountNonZeroPixels2DSphere.asInteger((Object)this.args[2]).intValue(), CountNonZeroPixels2DSphere.asInteger((Object)this.args[3]).intValue());
    }

    @Deprecated
    public static boolean countNonZeroPixelsLocally(CLIJ2 clij2, ClearCLBuffer src, ClearCLBuffer dst, Integer radiusX, Integer radiusY) {
        return CountNonZeroPixels2DSphere.countNonZeroPixels2DSphere(clij2, src, dst, radiusX, radiusY);
    }

    public static boolean countNonZeroPixels2DSphere(CLIJ2 clij2, ClearCLBuffer src, ClearCLBuffer dst, Integer radiusX, Integer radiusY) {
        CLIJUtilities.assertDifferent((Object)src, (Object)dst);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("Nx", CLIJUtilities.radiusToKernelSize((int)radiusX));
        parameters.put("Ny", CLIJUtilities.radiusToKernelSize((int)radiusY));
        parameters.put("src", src);
        parameters.put("dst", dst);
        clij2.execute(CountNonZeroPixels2DSphere.class, "count_nonzero_pixels_sphere_2d_x.cl", "count_nonzero_pixels_sphere_2d", dst.getDimensions(), dst.getDimensions(), parameters);
        return true;
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination, Number radiusX, Number radiusY";
    }

    public String getDescription() {
        return "Counts non-zero pixels in a sphere around every pixel. \n\nPut the number in the result image.";
    }

    public String getAvailableForDimensions() {
        return "2D";
    }
}

