/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_create3D")
public class Create3D
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation {
    public Object[] getDefaultValues() {
        return new Object[]{null, 100, 100, 100, 32};
    }

    public boolean executeCL() {
        return true;
    }

    public String getParameterHelpText() {
        return "ByRef Image destination, Number width, Number height, Number depth, Number bitDepth";
    }

    public String getDescription() {
        return "Allocated memory for a new 3D image in the GPU memory.\n\nParameters\n----------\ndestination : Image\n    The new image will be stored in this variable.\nwidth : Number\n    The width of the new image.\nheight : Number\n    The height of the new image.\ndepth : Number\n    The depth of the new image.\nbit-depth : Number\n    The bit-depth of the new image. Can be either 8, 16 or 32, to create an image of unsigned-byte, unsigned-short or float type.\n";
    }

    public String getAvailableForDimensions() {
        return "3D";
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        NativeTypeEnum typeEnum = NativeTypeEnum.Float;
        if (Create3D.asInteger((Object)this.args[4]) == 8) {
            typeEnum = NativeTypeEnum.UnsignedByte;
        } else if (Create3D.asInteger((Object)this.args[4]) == 16) {
            typeEnum = NativeTypeEnum.UnsignedShort;
        }
        return this.getCLIJ2().create(new long[]{Create3D.asInteger((Object)this.args[1]).intValue(), Create3D.asInteger((Object)this.args[2]).intValue(), Create3D.asInteger((Object)this.args[3]).intValue()}, typeEnum);
    }
}

