/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_crop2D")
public class Crop2D
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Transform";
    }

    public Object[] getDefaultValues() {
        return new Object[]{null, null, 0, 0, 100, 100};
    }

    public boolean executeCL() {
        return this.getCLIJ2().crop((ClearCLImageInterface)((ClearCLBuffer)this.args[0]), (ClearCLImageInterface)((ClearCLBuffer)this.args[1]), Crop2D.asInteger((Object)this.args[2]).intValue(), Crop2D.asInteger((Object)this.args[3]).intValue());
    }

    public static boolean crop2D(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, Integer startX, Integer startY) {
        return Crop2D.crop(clij2, src, dst, startX, startY);
    }

    public static boolean crop(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, Integer startX, Integer startY) {
        CLIJUtilities.assertDifferent((Object)src, (Object)dst);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src", src);
        parameters.put("dst", dst);
        parameters.put("start_x", startX);
        parameters.put("start_y", startY);
        clij2.activateSizeIndependentKernelCompilation();
        clij2.execute(Crop2D.class, "crop_2d_x.cl", "crop_2d", dst.getDimensions(), dst.getDimensions(), parameters);
        return true;
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination, Number start_x, Number start_z, Number width, Number height";
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        int width = Crop2D.asInteger((Object)this.args[4]);
        int height = Crop2D.asInteger((Object)this.args[5]);
        return this.clij.createCLBuffer(new long[]{width, height}, input.getNativeType());
    }

    public String getDescription() {
        return "Crops a given rectangle out of a given image. \n\nNote: If the destination image pre-exists already, it will be overwritten and keep it's dimensions.\n\nParameters\n----------\nsource : Image\n    The image where a part will be cropped out.\ndestination : Image\n    The cropped image will be stored in this variable.\nstart_x : Number\n    The horizontal position of the region to crop in the source image.\nstart_y : Number\n    The vertical position of the region to crop in the source image.\nwidth : Number\n    The width of the region to crop in the source image.\nheight : Number\n    The height of the region to crop in the source image.\n";
    }

    public String getAvailableForDimensions() {
        return "3D";
    }
}

