/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_crop3D")
public class Crop3D
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Transform";
    }

    public Object[] getDefaultValues() {
        if (default_values != null) {
            return default_values;
        }
        return new Object[]{null, null, 0, 0, 0, 100, 100, 10};
    }

    public boolean executeCL() {
        return this.getCLIJ2().crop((ClearCLImageInterface)((ClearCLBuffer)this.args[0]), (ClearCLImageInterface)((ClearCLBuffer)this.args[1]), Crop3D.asInteger((Object)this.args[2]).intValue(), Crop3D.asInteger((Object)this.args[3]).intValue(), Crop3D.asInteger((Object)this.args[4]).intValue());
    }

    public static boolean crop3D(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, Integer startX, Integer startY, Integer startZ) {
        return Crop3D.crop(clij2, src, dst, startX, startY, startZ);
    }

    public static boolean crop(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, Integer startX, Integer startY, Integer startZ) {
        CLIJUtilities.assertDifferent((Object)src, (Object)dst);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src", src);
        parameters.put("dst", dst);
        parameters.put("start_x", startX);
        parameters.put("start_y", startY);
        parameters.put("start_z", startZ);
        clij2.activateSizeIndependentKernelCompilation();
        clij2.execute(Crop3D.class, "crop_3d_x.cl", "crop_3d", dst.getDimensions(), dst.getDimensions(), parameters);
        return true;
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination, Number start_x, Number start_y, Number start_z, Number width, Number height, Number depth";
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        int width = Crop3D.asInteger((Object)this.args[5]);
        int height = Crop3D.asInteger((Object)this.args[6]);
        int depth = Crop3D.asInteger((Object)this.args[7]);
        return this.clij.createCLBuffer(new long[]{width, height, depth}, input.getNativeType());
    }

    public String getDescription() {
        return "Crops a given sub-stack out of a given image stack. \n\nNote: If the destination image pre-exists already, it will be overwritten and keep it's dimensions.\n\nParameters\n----------\nsource : Image\n    The image where a part will be cropped out.\ndestination : Image\n    The cropped image will be stored in this variable.\nstart_x : Number\n    The horizontal position of the region to crop in the source image.\nstart_y : Number\n    The vertical position of the region to crop in the source image.\nstart_z : Number\n    The slice position of the region to crop in the source image. Slices are counted 0-based; the first slice is z=0.\nwidth : Number\n    The width of the region to crop in the source image.\nheight : Number\n    The height of the region to crop in the source image.\ndepth : Number\n    The depth of the region to crop in the source image.\n";
    }

    public String getAvailableForDimensions() {
        return "3D";
    }
}

