/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.macro.CLIJHandler;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasAuthor;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_customOperation")
public class CustomOperation
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
HasAuthor {
    public boolean executeCL() {
        String operation_code = (String)this.args[0];
        String global_code = (String)this.args[1];
        Object[] image_parameter_list = (Object[])this.args[2];
        HashMap<String, ClearCLBuffer> images = new HashMap<String, ClearCLBuffer>();
        for (int i = 0; i < image_parameter_list.length; i += 2) {
            String parameterName = (String)image_parameter_list[i];
            ClearCLBuffer imageParameter = CLIJHandler.getInstance().getFromCache((String)image_parameter_list[i + 1]);
            images.put(parameterName, imageParameter);
        }
        return this.getCLIJ2().customOperation(operation_code, global_code, images);
    }

    public static boolean customOperation(CLIJ2 clij2, String operation_code, String global_code, HashMap<String, ClearCLBuffer> images) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        HashMap<String, Object> constants = new HashMap<String, Object>();
        StringBuilder parameterList = new StringBuilder();
        long[] dimensions = null;
        for (String key : images.keySet()) {
            ClearCLBuffer buffer = images.get(key);
            dimensions = buffer.getDimensions();
            if (parameterList.length() > 0) {
                parameterList.append(", ");
            }
            parameterList.append("IMAGE_" + key + "_TYPE " + key);
            parameters.put(key, buffer);
        }
        String code = "const sampler_t sampler = CLK_NORMALIZED_COORDS_FALSE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;\n\n" + global_code + "\n__kernel void custom_operation(" + parameterList.toString() + ") {\n  const int x = get_global_id(0);\n  const int y = get_global_id(1);\n  const int z = get_global_id(2);\n" + operation_code + "}\n";
        clij2.executeCode(code, "custom_operation", dimensions, dimensions, parameters, constants);
        return true;
    }

    public String getParameterHelpText() {
        return "String operation_code, String global_code, Array image_parameters";
    }

    public String getDescription() {
        return "Executes a custom operation wirtten in OpenCL on a custom list of images. \n\nAll images must be created before calling this method. Image parameters should be handed over as an array with parameter names and image names alternating, e.g.\n\nExt.CLIJ2_customOperation(..., ..., newArray(\"image1\", \"blobs.gif\", \"image2\", \"Processed_blobs.gif\"))\n\nIn the custom code, you can use the predefined variables x, y and z to deal with coordinates.\nYou can for example use it to access pixel intensities like this:\n\nfloat value = READ_IMAGE(image, sampler, POS_image_INSTANCE(x, y, z, 0)).x;\nWRITE_IMAGE(image, POS_image_INSTANCE(x, y, z, 0), CONVERT_image_PIXEL_TYPE(value));\n\nNote: replace `image` with the given image parameter name. You can furthermore use custom function to organise code in the global_code parameter. In OpenCL they may look like this:\n\ninline float sum(float a, float b) {\n    return a + b;\n}\n";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public String getAuthorName() {
        return "Robert Haase, Matthias Arzt";
    }
}

