/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_detectLabelEdges")
public class DetectLabelEdges
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Label Image";
    }

    @Override
    public String getOutputType() {
        return "Binary Image";
    }

    public boolean executeCL() {
        return this.getCLIJ2().detectLabelEdges((ClearCLImageInterface)((ClearCLBuffer)this.args[0]), (ClearCLBuffer)this.args[1]);
    }

    public static boolean detectLabelEdges(CLIJ2 clij2, ClearCLImageInterface src_label_map, ClearCLBuffer dst_edge_image) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src_label_map", src_label_map);
        parameters.put("dst_edge_image", dst_edge_image);
        clij2.execute(DetectLabelEdges.class, "detect_label_edges_" + src_label_map.getDimension() + "d_x.cl", "detect_label_edges_diamond_" + src_label_map.getDimension() + "d", dst_edge_image.getDimensions(), dst_edge_image.getDimensions(), parameters);
        return true;
    }

    public String getParameterHelpText() {
        return "Image label_map, ByRef Image edge_image_destination";
    }

    public String getDescription() {
        return "Takes a labelmap and returns an image where all pixels on label edges are set to 1 and all other pixels to 0.\n\nParameters\n----------\nlabel_map : Image\n    The label image where edges between labels will be detected.\nedge_image_destination : Number\n    Binary image where edges were marked with value 1 and all other pixels will be set to 0.\n";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public String getCategories() {
        return "Label, Filter, Detection";
    }
}

