/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_detectMinimaSliceBySliceBox")
public class DetectMinimaSliceBySliceBox
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Binary Image";
    }

    public boolean executeCL() {
        return this.getCLIJ2().detectMinimaSliceBySliceBox((ClearCLBuffer)this.args[0], (ClearCLBuffer)this.args[1], DetectMinimaSliceBySliceBox.asInteger((Object)this.args[2]).intValue(), DetectMinimaSliceBySliceBox.asInteger((Object)this.args[3]).intValue());
    }

    public static boolean detectMinimaSliceBySliceBox(CLIJ2 clij2, ClearCLBuffer src, ClearCLBuffer dst, Integer radiusX, Integer radiusY) {
        net.haesleinhuepf.clij.utilities.CLIJUtilities.assertDifferent((Object)src, (Object)dst);
        if (!CLIJUtilities.checkDimensions(src.getDimension(), dst.getDimension())) {
            throw new IllegalArgumentException("Error: number of dimensions don't match! (detectOptima)");
        }
        ClearCLBuffer temp = clij2.create(dst.getDimensions(), clij2.Float);
        clij2.meanBox((ClearCLImageInterface)src, (ClearCLImageInterface)temp, radiusX.intValue(), radiusY.intValue(), 0.0);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src", temp);
        parameters.put("dst", dst);
        clij2.execute(DetectMinimaSliceBySliceBox.class, "detect_minima_3d_slice_by_slice_x.cl", "detect_minima_3d_slice_by_slice", dst.getDimensions(), dst.getDimensions(), parameters);
        temp.close();
        return true;
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination, Number radiusX, Number RadiusY";
    }

    public String getDescription() {
        return "Detects local minima in a given square neighborhood of an input image stack. \n\nThe input image stack is processed slice by slice. Pixels in the resulting image are set to 1 if \nthere is no other pixel in a given radius which has a lower intensity, and to 0 otherwise.";
    }

    public String getAvailableForDimensions() {
        return "3D";
    }

    public String getCategories() {
        return "Binary, Detection";
    }
}

