/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_differenceOfGaussian2D")
public class DifferenceOfGaussian2D
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Background, Noise, Filter";
    }

    public Object[] getDefaultValues() {
        return new Object[]{null, null, 2, 2, 10, 10};
    }

    public String getParameterHelpText() {
        return "Image input, ByRef Image destination, Number sigma1x, Number sigma1y, Number sigma2x, Number sigma2y";
    }

    public boolean executeCL() {
        boolean result = this.getCLIJ2().differenceOfGaussian((ClearCLBuffer)this.args[0], (ClearCLBuffer)this.args[1], DifferenceOfGaussian2D.asFloat((Object)this.args[2]).floatValue(), DifferenceOfGaussian2D.asFloat((Object)this.args[3]).floatValue(), DifferenceOfGaussian2D.asFloat((Object)this.args[4]).floatValue(), DifferenceOfGaussian2D.asFloat((Object)this.args[5]).floatValue());
        return result;
    }

    public static boolean differenceOfGaussian2D(CLIJ2 clij2, ClearCLBuffer input, ClearCLBuffer output, Float sigma1x, Float sigma1y, Float sigma2x, Float sigma2y) {
        return DifferenceOfGaussian2D.differenceOfGaussian(clij2, input, output, sigma1x, sigma1y, sigma2x, sigma2y);
    }

    public static boolean differenceOfGaussian(CLIJ2 clij2, ClearCLBuffer input, ClearCLBuffer output, Float sigma1x, Float sigma1y, Float sigma2x, Float sigma2y) {
        ClearCLBuffer temp1 = clij2.create(input);
        ClearCLBuffer temp2 = clij2.create(input);
        clij2.gaussianBlur((ClearCLImageInterface)input, (ClearCLImageInterface)temp1, sigma1x.floatValue(), sigma1y.floatValue());
        clij2.gaussianBlur((ClearCLImageInterface)input, (ClearCLImageInterface)temp2, sigma2x.floatValue(), sigma2y.floatValue());
        clij2.subtractImages((ClearCLImageInterface)temp1, (ClearCLImageInterface)temp2, (ClearCLImageInterface)output);
        clij2.release((ClearCLImageInterface)temp1);
        clij2.release((ClearCLImageInterface)temp2);
        return true;
    }

    public String getDescription() {
        return "Applies Gaussian blur to the input image twice with different sigma values resulting in two images which are then subtracted from each other.\n\nIt is recommended to apply this operation to images of type Float (32 bit) as results might be negative.\n\nParameters\n----------\ninput : Image\n    The input image to be processed.\ndestination : Image\n    The output image where results are written into.\nsigma1_x : float\n    Sigma of the first Gaussian filter in x\nsigma1_y : float\n    Sigma of the first Gaussian filter in y\nsigma2_x : float\n    Sigma of the second Gaussian filter in x\nsigma2_y : float\n    Sigma of the second Gaussian filter in y";
    }

    public String getAvailableForDimensions() {
        return "2D";
    }
}

