/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_distanceMap")
public class DistanceMap
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Binary Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public boolean executeCL() {
        Object[] args = this.openCLBufferArgs();
        ClearCLBuffer src = (ClearCLBuffer)args[0];
        ClearCLBuffer dst = (ClearCLBuffer)args[1];
        this.getCLIJ2().distanceMap(src, dst);
        return true;
    }

    public static boolean distanceMap(CLIJ2 clij2, ClearCLBuffer src, ClearCLBuffer dst) {
        ClearCLBuffer flag = clij2.create(new long[]{1L, 1L, 1L});
        float[] flagValue = new float[]{1.0f};
        ClearCLBuffer temp1 = clij2.create(dst.getDimensions(), NativeTypeEnum.Float);
        ClearCLBuffer temp2 = clij2.create(dst.getDimensions(), NativeTypeEnum.Float);
        ClearCLBuffer temp3 = clij2.create(dst.getDimensions(), NativeTypeEnum.Float);
        ClearCLBuffer temp4 = clij2.create(dst.getDimensions(), NativeTypeEnum.Float);
        clij2.greaterConstant((ClearCLImageInterface)src, (ClearCLImageInterface)temp1, 0.0);
        clij2.copy((ClearCLImageInterface)temp1, (ClearCLImageInterface)temp3);
        int iteration = 0;
        while (flagValue[0] > 0.0f) {
            flagValue[0] = 0.0f;
            flag.readFrom((Buffer)FloatBuffer.wrap(flagValue), true);
            if (iteration % 2 == 0) {
                DistanceMap.localPositiveMinimumDiamond(clij2, (ClearCLImageInterface)temp1, (ClearCLImageInterface)temp2, (ClearCLImageInterface)flag);
                clij2.addImages((ClearCLImageInterface)temp3, (ClearCLImageInterface)temp2, (ClearCLImageInterface)temp4);
            } else {
                DistanceMap.localPositiveMinimumBox(clij2, (ClearCLImageInterface)temp2, (ClearCLImageInterface)temp1, (ClearCLImageInterface)flag);
                clij2.addImages((ClearCLImageInterface)temp4, (ClearCLImageInterface)temp1, (ClearCLImageInterface)temp3);
            }
            flag.writeTo((Buffer)FloatBuffer.wrap(flagValue), true);
            ++iteration;
        }
        if (iteration % 2 != 0) {
            clij2.copy((ClearCLImageInterface)temp3, (ClearCLImageInterface)dst);
        } else {
            clij2.copy((ClearCLImageInterface)temp4, (ClearCLImageInterface)dst);
        }
        clij2.release((ClearCLImageInterface)temp1);
        clij2.release((ClearCLImageInterface)temp2);
        clij2.release((ClearCLImageInterface)temp3);
        clij2.release((ClearCLImageInterface)temp4);
        clij2.release((ClearCLImageInterface)flag);
        return true;
    }

    private static boolean localPositiveMinimumBox(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, ClearCLImageInterface flag_dst) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src", src);
        parameters.put("dst", dst);
        parameters.put("flag_dst", flag_dst);
        clij2.execute(DistanceMap.class, "distancemap_localPositiveMinimum_box_" + dst.getDimension() + "d_x.cl", "distancemap_local_positive_minimum_box_" + dst.getDimension() + "d", dst.getDimensions(), dst.getDimensions(), parameters);
        return true;
    }

    private static boolean localPositiveMinimumDiamond(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, ClearCLImageInterface flag_dst) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src", src);
        parameters.put("dst", dst);
        parameters.put("flag_dst", flag_dst);
        clij2.execute(DistanceMap.class, "distancemap_localPositiveMinimum_diamond_" + dst.getDimension() + "d_x.cl", "distancemap_local_positive_minimum_diamond_" + dst.getDimension() + "d", dst.getDimensions(), dst.getDimensions(), parameters);
        return true;
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination";
    }

    public String getDescription() {
        return "Generates a distance map from a binary image. \n\nPixels with non-zero value in the binary image are set to a number representing the distance to the closest zero-value pixel.\n\nNote: This is not a distance matrix. See generateDistanceMatrix for details.";
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        return this.getCLIJ2().create(input.getDimensions(), NativeTypeEnum.Float);
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public String getCategories() {
        return "Measurements, Filter, Binary";
    }
}

