/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.Arrays;
import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_divideImages")
public class DivideImages
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Math";
    }

    public boolean executeCL() {
        return this.getCLIJ2().divideImages((ClearCLImageInterface)((ClearCLBuffer)this.args[0]), (ClearCLImageInterface)((ClearCLBuffer)this.args[1]), (ClearCLImageInterface)((ClearCLBuffer)this.args[2]));
    }

    public static boolean divideImages(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface src1, ClearCLImageInterface dst) {
        net.haesleinhuepf.clij.utilities.CLIJUtilities.assertDifferent((Object)src, (Object)dst);
        net.haesleinhuepf.clij.utilities.CLIJUtilities.assertDifferent((Object)src1, (Object)dst);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src", src);
        parameters.put("src1", src1);
        parameters.put("dst", dst);
        if (!CLIJUtilities.checkDimensions(src.getDimension(), src1.getDimension(), dst.getDimension())) {
            throw new IllegalArgumentException("Error: number of dimensions don't match! (divideImages): " + Arrays.toString(src.getDimensions()) + " vs " + Arrays.toString(src1.getDimensions()) + " vs " + Arrays.toString(dst.getDimensions()));
        }
        clij2.execute(DivideImages.class, "divide_images_" + src.getDimension() + "d_x.cl", "divide_images_" + src.getDimension() + "d", dst.getDimensions(), dst.getDimensions(), parameters);
        return true;
    }

    public String getParameterHelpText() {
        return "Image divident, Image divisor, ByRef Image destination";
    }

    public String getDescription() {
        return "Divides two images X and Y by each other pixel wise. \n\n<pre>f(x, y) = x / y</pre>";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        return this.getCLIJ2().create(input.getDimensions(), NativeTypeEnum.Float);
    }
}

